// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An alert incident indicates the activation status of an alert rule. */
@Immutable
public final class IncidentInner {
    /*
     * Incident name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Rule name that is associated with the incident.
     */
    @JsonProperty(value = "ruleName", access = JsonProperty.Access.WRITE_ONLY)
    private String ruleName;

    /*
     * A boolean to indicate whether the incident is active or resolved.
     */
    @JsonProperty(value = "isActive", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isActive;

    /*
     * The time at which the incident was activated in ISO8601 format.
     */
    @JsonProperty(value = "activatedTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime activatedTime;

    /*
     * The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
     */
    @JsonProperty(value = "resolvedTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime resolvedTime;

    /** Creates an instance of IncidentInner class. */
    public IncidentInner() {
    }

    /**
     * Get the name property: Incident name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the ruleName property: Rule name that is associated with the incident.
     *
     * @return the ruleName value.
     */
    public String ruleName() {
        return this.ruleName;
    }

    /**
     * Get the isActive property: A boolean to indicate whether the incident is active or resolved.
     *
     * @return the isActive value.
     */
    public Boolean isActive() {
        return this.isActive;
    }

    /**
     * Get the activatedTime property: The time at which the incident was activated in ISO8601 format.
     *
     * @return the activatedTime value.
     */
    public OffsetDateTime activatedTime() {
        return this.activatedTime;
    }

    /**
     * Get the resolvedTime property: The time at which the incident was resolved in ISO8601 format. If null, it means
     * the incident is still active.
     *
     * @return the resolvedTime value.
     */
    public OffsetDateTime resolvedTime() {
        return this.resolvedTime;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
