// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Event hub receiver. */
@Fluent
public final class EventHubReceiver {
    /*
     * The name of the Event hub receiver. Names must be unique across all receivers within an action group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The Event Hub namespace
     */
    @JsonProperty(value = "eventHubNameSpace", required = true)
    private String eventHubNameSpace;

    /*
     * The name of the specific Event Hub queue
     */
    @JsonProperty(value = "eventHubName", required = true)
    private String eventHubName;

    /*
     * Indicates whether to use common alert schema.
     */
    @JsonProperty(value = "useCommonAlertSchema")
    private Boolean useCommonAlertSchema;

    /*
     * The tenant Id for the subscription containing this event hub
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /*
     * The Id for the subscription containing this event hub
     */
    @JsonProperty(value = "subscriptionId", required = true)
    private String subscriptionId;

    /** Creates an instance of EventHubReceiver class. */
    public EventHubReceiver() {
    }

    /**
     * Get the name property: The name of the Event hub receiver. Names must be unique across all receivers within an
     * action group.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the Event hub receiver. Names must be unique across all receivers within an
     * action group.
     *
     * @param name the name value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the eventHubNameSpace property: The Event Hub namespace.
     *
     * @return the eventHubNameSpace value.
     */
    public String eventHubNameSpace() {
        return this.eventHubNameSpace;
    }

    /**
     * Set the eventHubNameSpace property: The Event Hub namespace.
     *
     * @param eventHubNameSpace the eventHubNameSpace value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withEventHubNameSpace(String eventHubNameSpace) {
        this.eventHubNameSpace = eventHubNameSpace;
        return this;
    }

    /**
     * Get the eventHubName property: The name of the specific Event Hub queue.
     *
     * @return the eventHubName value.
     */
    public String eventHubName() {
        return this.eventHubName;
    }

    /**
     * Set the eventHubName property: The name of the specific Event Hub queue.
     *
     * @param eventHubName the eventHubName value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    /**
     * Get the useCommonAlertSchema property: Indicates whether to use common alert schema.
     *
     * @return the useCommonAlertSchema value.
     */
    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    /**
     * Set the useCommonAlertSchema property: Indicates whether to use common alert schema.
     *
     * @param useCommonAlertSchema the useCommonAlertSchema value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    /**
     * Get the tenantId property: The tenant Id for the subscription containing this event hub.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant Id for the subscription containing this event hub.
     *
     * @param tenantId the tenantId value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the subscriptionId property: The Id for the subscription containing this event hub.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: The Id for the subscription containing this event hub.
     *
     * @param subscriptionId the subscriptionId value to set.
     * @return the EventHubReceiver object itself.
     */
    public EventHubReceiver withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model EventHubReceiver"));
        }
        if (eventHubNameSpace() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property eventHubNameSpace in model EventHubReceiver"));
        }
        if (eventHubName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property eventHubName in model EventHubReceiver"));
        }
        if (subscriptionId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property subscriptionId in model EventHubReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EventHubReceiver.class);
}
