// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Settings for different log file formats. */
@Fluent
public class LogFileSettings {
    /*
     * Text settings
     */
    @JsonProperty(value = "text")
    private LogFileSettingsText text;

    /** Creates an instance of LogFileSettings class. */
    public LogFileSettings() {
    }

    /**
     * Get the text property: Text settings.
     *
     * @return the text value.
     */
    public LogFileSettingsText text() {
        return this.text;
    }

    /**
     * Set the text property: Text settings.
     *
     * @param text the text value to set.
     * @return the LogFileSettings object itself.
     */
    public LogFileSettings withText(LogFileSettingsText text) {
        this.text = text;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (text() != null) {
            text().validate();
        }
    }
}
