// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.azure.resourcemanager.network.models.VirtualNetworkEncryption;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Virtual Network resource. */
@Fluent
public final class VirtualNetworkInner extends Resource {
    /*
     * The extended location of the virtual network.
     */
    @JsonProperty(value = "extendedLocation")
    private ExtendedLocation extendedLocation;

    /*
     * Properties of the virtual network.
     */
    @JsonProperty(value = "properties")
    private VirtualNetworkPropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /** Creates an instance of VirtualNetworkInner class. */
    public VirtualNetworkInner() {
    }

    /**
     * Get the extendedLocation property: The extended location of the virtual network.
     *
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: The extended location of the virtual network.
     *
     * @param extendedLocation the extendedLocation value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the virtual network.
     *
     * @return the innerProperties value.
     */
    private VirtualNetworkPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     *
     * @param id the id value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withId(String id) {
        this.id = id;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the addressSpace property: The AddressSpace that contains an array of IP address ranges that can be used by
     * subnets.
     *
     * @return the addressSpace value.
     */
    public AddressSpace addressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().addressSpace();
    }

    /**
     * Set the addressSpace property: The AddressSpace that contains an array of IP address ranges that can be used by
     * subnets.
     *
     * @param addressSpace the addressSpace value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withAddressSpace(AddressSpace addressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withAddressSpace(addressSpace);
        return this;
    }

    /**
     * Get the dhcpOptions property: The dhcpOptions that contains an array of DNS servers available to VMs deployed in
     * the virtual network.
     *
     * @return the dhcpOptions value.
     */
    public DhcpOptions dhcpOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().dhcpOptions();
    }

    /**
     * Set the dhcpOptions property: The dhcpOptions that contains an array of DNS servers available to VMs deployed in
     * the virtual network.
     *
     * @param dhcpOptions the dhcpOptions value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withDhcpOptions(DhcpOptions dhcpOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDhcpOptions(dhcpOptions);
        return this;
    }

    /**
     * Get the flowTimeoutInMinutes property: The FlowTimeout value (in minutes) for the Virtual Network.
     *
     * @return the flowTimeoutInMinutes value.
     */
    public Integer flowTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().flowTimeoutInMinutes();
    }

    /**
     * Set the flowTimeoutInMinutes property: The FlowTimeout value (in minutes) for the Virtual Network.
     *
     * @param flowTimeoutInMinutes the flowTimeoutInMinutes value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withFlowTimeoutInMinutes(Integer flowTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withFlowTimeoutInMinutes(flowTimeoutInMinutes);
        return this;
    }

    /**
     * Get the subnets property: A list of subnets in a Virtual Network.
     *
     * @return the subnets value.
     */
    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    /**
     * Set the subnets property: A list of subnets in a Virtual Network.
     *
     * @param subnets the subnets value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withSubnets(List<SubnetInner> subnets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withSubnets(subnets);
        return this;
    }

    /**
     * Get the virtualNetworkPeerings property: A list of peerings in a Virtual Network.
     *
     * @return the virtualNetworkPeerings value.
     */
    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkPeerings();
    }

    /**
     * Set the virtualNetworkPeerings property: A list of peerings in a Virtual Network.
     *
     * @param virtualNetworkPeerings the virtualNetworkPeerings value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withVirtualNetworkPeerings(virtualNetworkPeerings);
        return this;
    }

    /**
     * Get the resourceGuid property: The resourceGuid property of the Virtual Network resource.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual network resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the enableDdosProtection property: Indicates if DDoS protection is enabled for all the protected resources in
     * the virtual network. It requires a DDoS protection plan associated with the resource.
     *
     * @return the enableDdosProtection value.
     */
    public Boolean enableDdosProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDdosProtection();
    }

    /**
     * Set the enableDdosProtection property: Indicates if DDoS protection is enabled for all the protected resources in
     * the virtual network. It requires a DDoS protection plan associated with the resource.
     *
     * @param enableDdosProtection the enableDdosProtection value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withEnableDdosProtection(Boolean enableDdosProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableDdosProtection(enableDdosProtection);
        return this;
    }

    /**
     * Get the enableVmProtection property: Indicates if VM protection is enabled for all the subnets in the virtual
     * network.
     *
     * @return the enableVmProtection value.
     */
    public Boolean enableVmProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enableVmProtection();
    }

    /**
     * Set the enableVmProtection property: Indicates if VM protection is enabled for all the subnets in the virtual
     * network.
     *
     * @param enableVmProtection the enableVmProtection value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withEnableVmProtection(Boolean enableVmProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEnableVmProtection(enableVmProtection);
        return this;
    }

    /**
     * Get the ddosProtectionPlan property: The DDoS protection plan associated with the virtual network.
     *
     * @return the ddosProtectionPlan value.
     */
    public SubResource ddosProtectionPlan() {
        return this.innerProperties() == null ? null : this.innerProperties().ddosProtectionPlan();
    }

    /**
     * Set the ddosProtectionPlan property: The DDoS protection plan associated with the virtual network.
     *
     * @param ddosProtectionPlan the ddosProtectionPlan value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withDdosProtectionPlan(ddosProtectionPlan);
        return this;
    }

    /**
     * Get the bgpCommunities property: Bgp Communities sent over ExpressRoute with each route corresponding to a prefix
     * in this VNET.
     *
     * @return the bgpCommunities value.
     */
    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpCommunities();
    }

    /**
     * Set the bgpCommunities property: Bgp Communities sent over ExpressRoute with each route corresponding to a prefix
     * in this VNET.
     *
     * @param bgpCommunities the bgpCommunities value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withBgpCommunities(bgpCommunities);
        return this;
    }

    /**
     * Get the encryption property: Indicates if encryption is enabled on virtual network and if VM without encryption
     * is allowed in encrypted VNet.
     *
     * @return the encryption value.
     */
    public VirtualNetworkEncryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    /**
     * Set the encryption property: Indicates if encryption is enabled on virtual network and if VM without encryption
     * is allowed in encrypted VNet.
     *
     * @param encryption the encryption value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withEncryption(VirtualNetworkEncryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    /**
     * Get the ipAllocations property: Array of IpAllocation which reference this VNET.
     *
     * @return the ipAllocations value.
     */
    public List<SubResource> ipAllocations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocations();
    }

    /**
     * Set the ipAllocations property: Array of IpAllocation which reference this VNET.
     *
     * @param ipAllocations the ipAllocations value to set.
     * @return the VirtualNetworkInner object itself.
     */
    public VirtualNetworkInner withIpAllocations(List<SubResource> ipAllocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkPropertiesFormat();
        }
        this.innerProperties().withIpAllocations(ipAllocations);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
