// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.OfficeTrafficCategory;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** VirtualWAN Resource. */
@Fluent
public final class VirtualWanInner extends Resource {
    /*
     * Properties of the virtual WAN.
     */
    @JsonProperty(value = "properties")
    private VirtualWanProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /** Creates an instance of VirtualWanInner class. */
    public VirtualWanInner() {
    }

    /**
     * Get the innerProperties property: Properties of the virtual WAN.
     *
     * @return the innerProperties value.
     */
    private VirtualWanProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     *
     * @param id the id value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withId(String id) {
        this.id = id;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualWanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VirtualWanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the disableVpnEncryption property: Vpn encryption to be disabled or not.
     *
     * @return the disableVpnEncryption value.
     */
    public Boolean disableVpnEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().disableVpnEncryption();
    }

    /**
     * Set the disableVpnEncryption property: Vpn encryption to be disabled or not.
     *
     * @param disableVpnEncryption the disableVpnEncryption value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withDisableVpnEncryption(disableVpnEncryption);
        return this;
    }

    /**
     * Get the virtualHubs property: List of VirtualHubs in the VirtualWAN.
     *
     * @return the virtualHubs value.
     */
    public List<SubResource> virtualHubs() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHubs();
    }

    /**
     * Get the vpnSites property: List of VpnSites in the VirtualWAN.
     *
     * @return the vpnSites value.
     */
    public List<SubResource> vpnSites() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSites();
    }

    /**
     * Get the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     *
     * @return the allowBranchToBranchTraffic value.
     */
    public Boolean allowBranchToBranchTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBranchToBranchTraffic();
    }

    /**
     * Set the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     *
     * @param allowBranchToBranchTraffic the allowBranchToBranchTraffic value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowBranchToBranchTraffic(allowBranchToBranchTraffic);
        return this;
    }

    /**
     * Get the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     *
     * @return the allowVnetToVnetTraffic value.
     */
    public Boolean allowVnetToVnetTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowVnetToVnetTraffic();
    }

    /**
     * Set the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     *
     * @param allowVnetToVnetTraffic the allowVnetToVnetTraffic value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowVnetToVnetTraffic(allowVnetToVnetTraffic);
        return this;
    }

    /**
     * Get the office365LocalBreakoutCategory property: The office local breakout category.
     *
     * @return the office365LocalBreakoutCategory value.
     */
    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.innerProperties() == null ? null : this.innerProperties().office365LocalBreakoutCategory();
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual WAN resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the type property: The type of the VirtualWAN.
     *
     * @return the type value.
     */
    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: The type of the VirtualWAN.
     *
     * @param type the type value to set.
     * @return the VirtualWanInner object itself.
     */
    public VirtualWanInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
