// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.NetworkWatchersClient;
import com.azure.resourcemanager.network.fluent.models.AvailableProvidersListInner;
import com.azure.resourcemanager.network.fluent.models.AzureReachabilityReportInner;
import com.azure.resourcemanager.network.fluent.models.ConnectivityInformationInner;
import com.azure.resourcemanager.network.fluent.models.FlowLogInformationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkConfigurationDiagnosticResponseInner;
import com.azure.resourcemanager.network.fluent.models.NetworkWatcherInner;
import com.azure.resourcemanager.network.fluent.models.NextHopResultInner;
import com.azure.resourcemanager.network.fluent.models.SecurityGroupViewResultInner;
import com.azure.resourcemanager.network.fluent.models.TopologyInner;
import com.azure.resourcemanager.network.fluent.models.TroubleshootingResultInner;
import com.azure.resourcemanager.network.fluent.models.VerificationIpFlowResultInner;
import com.azure.resourcemanager.network.models.AvailableProvidersListParameters;
import com.azure.resourcemanager.network.models.AzureReachabilityReportParameters;
import com.azure.resourcemanager.network.models.ConnectivityParameters;
import com.azure.resourcemanager.network.models.FlowLogStatusParameters;
import com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticParameters;
import com.azure.resourcemanager.network.models.NetworkWatcherListResult;
import com.azure.resourcemanager.network.models.NextHopParameters;
import com.azure.resourcemanager.network.models.QueryTroubleshootingParameters;
import com.azure.resourcemanager.network.models.SecurityGroupViewParameters;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.TopologyParameters;
import com.azure.resourcemanager.network.models.TroubleshootingParameters;
import com.azure.resourcemanager.network.models.VerificationIpFlowParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in NetworkWatchersClient. */
public final class NetworkWatchersClientImpl
    implements InnerSupportsGet<NetworkWatcherInner>,
        InnerSupportsListing<NetworkWatcherInner>,
        InnerSupportsDelete<Void>,
        NetworkWatchersClient {
    /** The proxy service used to perform REST calls. */
    private final NetworkWatchersService service;

    /** The service client containing this operation class. */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of NetworkWatchersClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    NetworkWatchersClientImpl(NetworkManagementClientImpl client) {
        this.service =
            RestProxy.create(NetworkWatchersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientNetworkWatchers to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    public interface NetworkWatchersService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkWatcherInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") NetworkWatcherInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkWatcherInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkWatcherInner>> updateTags(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") TagsObject parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkWatcherListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkWatchers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkWatcherListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/topology")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TopologyInner>> getTopology(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") TopologyParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/ipFlowVerify")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> verifyIpFlow(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") VerificationIpFlowParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/nextHop")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getNextHop(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") NextHopParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/securityGroupView")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getVMSecurityRules(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") SecurityGroupViewParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/troubleshoot")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getTroubleshooting(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") TroubleshootingParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/queryTroubleshootResult")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getTroubleshootingResult(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") QueryTroubleshootingParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/configureFlowLog")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> setFlowLogConfiguration(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") FlowLogInformationInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/queryFlowLogStatus")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getFlowLogStatus(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") FlowLogStatusParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/connectivityCheck")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> checkConnectivity(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ConnectivityParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/azureReachabilityReport")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getAzureReachabilityReport(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") AzureReachabilityReportParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/availableProvidersList")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> listAvailableProviders(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") AvailableProvidersListParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/networkWatchers/{networkWatcherName}/networkConfigurationDiagnostic")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> getNetworkConfigurationDiagnostic(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkWatcherName") String networkWatcherName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") NetworkConfigurationDiagnosticParameters parameters,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NetworkWatcherInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NetworkWatcherInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NetworkWatcherInner> createOrUpdateAsync(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        return createOrUpdateWithResponseAsync(resourceGroupName, networkWatcherName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NetworkWatcherInner> createOrUpdateWithResponse(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkWatcherInner createOrUpdate(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters) {
        return createOrUpdateWithResponse(resourceGroupName, networkWatcherName, parameters, Context.NONE).getValue();
    }

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NetworkWatcherInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String networkWatcherName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NetworkWatcherInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String networkWatcherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NetworkWatcherInner> getByResourceGroupAsync(String resourceGroupName, String networkWatcherName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, networkWatcherName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NetworkWatcherInner> getByResourceGroupWithResponse(
        String resourceGroupName, String networkWatcherName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, networkWatcherName, context).block();
    }

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkWatcherInner getByResourceGroup(String resourceGroupName, String networkWatcherName) {
        return getByResourceGroupWithResponse(resourceGroupName, networkWatcherName, Context.NONE).getValue();
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String networkWatcherName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String networkWatcherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, networkWatcherName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String networkWatcherName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, networkWatcherName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkWatcherName) {
        return beginDeleteAsync(resourceGroupName, networkWatcherName).getSyncPoller();
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, Context context) {
        return beginDeleteAsync(resourceGroupName, networkWatcherName, context).getSyncPoller();
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName) {
        return beginDeleteAsync(resourceGroupName, networkWatcherName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName, Context context) {
        return beginDeleteAsync(resourceGroupName, networkWatcherName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkWatcherName) {
        deleteAsync(resourceGroupName, networkWatcherName).block();
    }

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkWatcherName, Context context) {
        deleteAsync(resourceGroupName, networkWatcherName, context).block();
    }

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NetworkWatcherInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TagsObject parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateTags(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NetworkWatcherInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TagsObject parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateTags(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NetworkWatcherInner> updateTagsAsync(
        String resourceGroupName, String networkWatcherName, TagsObject parameters) {
        return updateTagsWithResponseAsync(resourceGroupName, networkWatcherName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NetworkWatcherInner> updateTagsWithResponse(
        String resourceGroupName, String networkWatcherName, TagsObject parameters, Context context) {
        return updateTagsWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkWatcherInner updateTags(String resourceGroupName, String networkWatcherName, TagsObject parameters) {
        return updateTagsWithResponse(resourceGroupName, networkWatcherName, parameters, Context.NONE).getValue();
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkWatcherInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<NetworkWatcherInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkWatcherInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<NetworkWatcherInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<NetworkWatcherInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkWatcherInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkWatcherInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkWatcherInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<NetworkWatcherInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkWatcherInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<NetworkWatcherInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync());
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<NetworkWatcherInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context));
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkWatcherInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Gets all network watchers by subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkWatcherInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TopologyInner>> getTopologyWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTopology(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TopologyInner>> getTopologyWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTopology(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TopologyInner> getTopologyAsync(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        return getTopologyWithResponseAsync(resourceGroupName, networkWatcherName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TopologyInner> getTopologyWithResponse(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters, Context context) {
        return getTopologyWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TopologyInner getTopology(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters) {
        return getTopologyWithResponse(resourceGroupName, networkWatcherName, parameters, Context.NONE).getValue();
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> verifyIpFlowWithResponseAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .verifyIpFlow(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> verifyIpFlowWithResponseAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .verifyIpFlow(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            verifyIpFlowWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<VerificationIpFlowResultInner, VerificationIpFlowResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                VerificationIpFlowResultInner.class,
                VerificationIpFlowResultInner.class,
                this.client.getContext());
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            verifyIpFlowWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<VerificationIpFlowResultInner, VerificationIpFlowResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                VerificationIpFlowResultInner.class,
                VerificationIpFlowResultInner.class,
                context);
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters) {
        return beginVerifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context) {
        return beginVerifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VerificationIpFlowResultInner> verifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters) {
        return beginVerifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<VerificationIpFlowResultInner> verifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context) {
        return beginVerifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VerificationIpFlowResultInner verifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters) {
        return verifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VerificationIpFlowResultInner verifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context) {
        return verifyIpFlowAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getNextHopWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getNextHop(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getNextHopWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getNextHop(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getNextHopWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<NextHopResultInner, NextHopResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                NextHopResultInner.class,
                NextHopResultInner.class,
                this.client.getContext());
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getNextHopWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<NextHopResultInner, NextHopResultInner>getLroResult(
                mono, this.client.getHttpPipeline(), NextHopResultInner.class, NextHopResultInner.class, context);
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return beginGetNextHopAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context) {
        return beginGetNextHopAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NextHopResultInner> getNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return beginGetNextHopAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<NextHopResultInner> getNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context) {
        return beginGetNextHopAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NextHopResultInner getNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters) {
        return getNextHopAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NextHopResultInner getNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context) {
        return getNextHopAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getVMSecurityRulesWithResponseAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getVMSecurityRules(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getVMSecurityRulesWithResponseAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getVMSecurityRules(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner>
        beginGetVMSecurityRulesAsync(
            String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getVMSecurityRulesWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<SecurityGroupViewResultInner, SecurityGroupViewResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                SecurityGroupViewResultInner.class,
                SecurityGroupViewResultInner.class,
                this.client.getContext());
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner>
        beginGetVMSecurityRulesAsync(
            String resourceGroupName,
            String networkWatcherName,
            SecurityGroupViewParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getVMSecurityRulesWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<SecurityGroupViewResultInner, SecurityGroupViewResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                SecurityGroupViewResultInner.class,
                SecurityGroupViewResultInner.class,
                context);
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner> beginGetVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters) {
        return beginGetVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner> beginGetVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context) {
        return beginGetVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecurityGroupViewResultInner> getVMSecurityRulesAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters) {
        return beginGetVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SecurityGroupViewResultInner> getVMSecurityRulesAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context) {
        return beginGetVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecurityGroupViewResultInner getVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters) {
        return getVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecurityGroupViewResultInner getVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context) {
        return getVMSecurityRulesAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getTroubleshootingWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTroubleshooting(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getTroubleshootingWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTroubleshooting(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getTroubleshootingWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<TroubleshootingResultInner, TroubleshootingResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TroubleshootingResultInner.class,
                TroubleshootingResultInner.class,
                this.client.getContext());
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getTroubleshootingWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<TroubleshootingResultInner, TroubleshootingResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TroubleshootingResultInner.class,
                TroubleshootingResultInner.class,
                context);
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return beginGetTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context) {
        return beginGetTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TroubleshootingResultInner> getTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return beginGetTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TroubleshootingResultInner> getTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context) {
        return beginGetTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TroubleshootingResultInner getTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters) {
        return getTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TroubleshootingResultInner getTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context) {
        return getTroubleshootingAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getTroubleshootingResultWithResponseAsync(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTroubleshootingResult(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getTroubleshootingResultWithResponseAsync(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTroubleshootingResult(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner>
        beginGetTroubleshootingResultAsync(
            String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getTroubleshootingResultWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<TroubleshootingResultInner, TroubleshootingResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TroubleshootingResultInner.class,
                TroubleshootingResultInner.class,
                this.client.getContext());
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner>
        beginGetTroubleshootingResultAsync(
            String resourceGroupName,
            String networkWatcherName,
            QueryTroubleshootingParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getTroubleshootingResultWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<TroubleshootingResultInner, TroubleshootingResultInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TroubleshootingResultInner.class,
                TroubleshootingResultInner.class,
                context);
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingResult(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters) {
        return beginGetTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingResult(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context) {
        return beginGetTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TroubleshootingResultInner> getTroubleshootingResultAsync(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters) {
        return beginGetTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TroubleshootingResultInner> getTroubleshootingResultAsync(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context) {
        return beginGetTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TroubleshootingResultInner getTroubleshootingResult(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters) {
        return getTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TroubleshootingResultInner getTroubleshootingResult(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context) {
        return getTroubleshootingResultAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> setFlowLogConfigurationWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .setFlowLogConfiguration(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> setFlowLogConfigurationWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .setFlowLogConfiguration(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            setFlowLogConfigurationWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<FlowLogInformationInner, FlowLogInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                FlowLogInformationInner.class,
                FlowLogInformationInner.class,
                this.client.getContext());
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            setFlowLogConfigurationWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<FlowLogInformationInner, FlowLogInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                FlowLogInformationInner.class,
                FlowLogInformationInner.class,
                context);
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return beginSetFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context) {
        return beginSetFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FlowLogInformationInner> setFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return beginSetFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FlowLogInformationInner> setFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context) {
        return beginSetFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FlowLogInformationInner setFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters) {
        return setFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FlowLogInformationInner setFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context) {
        return setFlowLogConfigurationAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getFlowLogStatusWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getFlowLogStatus(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getFlowLogStatusWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getFlowLogStatus(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getFlowLogStatusWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<FlowLogInformationInner, FlowLogInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                FlowLogInformationInner.class,
                FlowLogInformationInner.class,
                this.client.getContext());
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getFlowLogStatusWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<FlowLogInformationInner, FlowLogInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                FlowLogInformationInner.class,
                FlowLogInformationInner.class,
                context);
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters) {
        return beginGetFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context) {
        return beginGetFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FlowLogInformationInner> getFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters) {
        return beginGetFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FlowLogInformationInner> getFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context) {
        return beginGetFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FlowLogInformationInner getFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters) {
        return getFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FlowLogInformationInner getFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context) {
        return getFlowLogStatusAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> checkConnectivityWithResponseAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .checkConnectivity(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> checkConnectivityWithResponseAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .checkConnectivity(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner>
        beginCheckConnectivityAsync(
            String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            checkConnectivityWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<ConnectivityInformationInner, ConnectivityInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ConnectivityInformationInner.class,
                ConnectivityInformationInner.class,
                this.client.getContext());
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner>
        beginCheckConnectivityAsync(
            String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            checkConnectivityWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<ConnectivityInformationInner, ConnectivityInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ConnectivityInformationInner.class,
                ConnectivityInformationInner.class,
                context);
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner> beginCheckConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return beginCheckConnectivityAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner> beginCheckConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context) {
        return beginCheckConnectivityAsync(resourceGroupName, networkWatcherName, parameters, context).getSyncPoller();
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectivityInformationInner> checkConnectivityAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return beginCheckConnectivityAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ConnectivityInformationInner> checkConnectivityAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context) {
        return beginCheckConnectivityAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectivityInformationInner checkConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters) {
        return checkConnectivityAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectivityInformationInner checkConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context) {
        return checkConnectivityAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getAzureReachabilityReportWithResponseAsync(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getAzureReachabilityReport(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getAzureReachabilityReportWithResponseAsync(
        String resourceGroupName,
        String networkWatcherName,
        AzureReachabilityReportParameters parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getAzureReachabilityReport(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner>
        beginGetAzureReachabilityReportAsync(
            String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getAzureReachabilityReportWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<AzureReachabilityReportInner, AzureReachabilityReportInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AzureReachabilityReportInner.class,
                AzureReachabilityReportInner.class,
                this.client.getContext());
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner>
        beginGetAzureReachabilityReportAsync(
            String resourceGroupName,
            String networkWatcherName,
            AzureReachabilityReportParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getAzureReachabilityReportWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<AzureReachabilityReportInner, AzureReachabilityReportInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AzureReachabilityReportInner.class,
                AzureReachabilityReportInner.class,
                context);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner>
        beginGetAzureReachabilityReport(
            String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return beginGetAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner>
        beginGetAzureReachabilityReport(
            String resourceGroupName,
            String networkWatcherName,
            AzureReachabilityReportParameters parameters,
            Context context) {
        return beginGetAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters, context)
            .getSyncPoller();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AzureReachabilityReportInner> getAzureReachabilityReportAsync(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return beginGetAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AzureReachabilityReportInner> getAzureReachabilityReportAsync(
        String resourceGroupName,
        String networkWatcherName,
        AzureReachabilityReportParameters parameters,
        Context context) {
        return beginGetAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AzureReachabilityReportInner getAzureReachabilityReport(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters) {
        return getAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AzureReachabilityReportInner getAzureReachabilityReport(
        String resourceGroupName,
        String networkWatcherName,
        AzureReachabilityReportParameters parameters,
        Context context) {
        return getAzureReachabilityReportAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listAvailableProvidersWithResponseAsync(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listAvailableProviders(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listAvailableProvidersWithResponseAsync(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAvailableProviders(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner>
        beginListAvailableProvidersAsync(
            String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            listAvailableProvidersWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<AvailableProvidersListInner, AvailableProvidersListInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AvailableProvidersListInner.class,
                AvailableProvidersListInner.class,
                this.client.getContext());
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner>
        beginListAvailableProvidersAsync(
            String resourceGroupName,
            String networkWatcherName,
            AvailableProvidersListParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            listAvailableProvidersWithResponseAsync(resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<AvailableProvidersListInner, AvailableProvidersListInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AvailableProvidersListInner.class,
                AvailableProvidersListInner.class,
                context);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner> beginListAvailableProviders(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return beginListAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters).getSyncPoller();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner> beginListAvailableProviders(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context) {
        return beginListAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters, context)
            .getSyncPoller();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AvailableProvidersListInner> listAvailableProvidersAsync(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return beginListAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AvailableProvidersListInner> listAvailableProvidersAsync(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context) {
        return beginListAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AvailableProvidersListInner listAvailableProviders(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters) {
        return listAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AvailableProvidersListInner listAvailableProviders(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context) {
        return listAvailableProvidersAsync(resourceGroupName, networkWatcherName, parameters, context).block();
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> getNetworkConfigurationDiagnosticWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getNetworkConfigurationDiagnostic(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            networkWatcherName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getNetworkConfigurationDiagnosticWithResponseAsync(
        String resourceGroupName,
        String networkWatcherName,
        NetworkConfigurationDiagnosticParameters parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkWatcherName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getNetworkConfigurationDiagnostic(
                this.client.getEndpoint(),
                resourceGroupName,
                networkWatcherName,
                apiVersion,
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<
            PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnosticAsync(
            String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            getNetworkConfigurationDiagnosticWithResponseAsync(resourceGroupName, networkWatcherName, parameters);
        return this
            .client
            .<NetworkConfigurationDiagnosticResponseInner, NetworkConfigurationDiagnosticResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                NetworkConfigurationDiagnosticResponseInner.class,
                NetworkConfigurationDiagnosticResponseInner.class,
                this.client.getContext());
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<
            PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnosticAsync(
            String resourceGroupName,
            String networkWatcherName,
            NetworkConfigurationDiagnosticParameters parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            getNetworkConfigurationDiagnosticWithResponseAsync(
                resourceGroupName, networkWatcherName, parameters, context);
        return this
            .client
            .<NetworkConfigurationDiagnosticResponseInner, NetworkConfigurationDiagnosticResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                NetworkConfigurationDiagnosticResponseInner.class,
                NetworkConfigurationDiagnosticResponseInner.class,
                context);
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<
            PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnostic(
            String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters) {
        return beginGetNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters)
            .getSyncPoller();
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<
            PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnostic(
            String resourceGroupName,
            String networkWatcherName,
            NetworkConfigurationDiagnosticParameters parameters,
            Context context) {
        return beginGetNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NetworkConfigurationDiagnosticResponseInner> getNetworkConfigurationDiagnosticAsync(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters) {
        return beginGetNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<NetworkConfigurationDiagnosticResponseInner> getNetworkConfigurationDiagnosticAsync(
        String resourceGroupName,
        String networkWatcherName,
        NetworkConfigurationDiagnosticParameters parameters,
        Context context) {
        return beginGetNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkConfigurationDiagnosticResponseInner getNetworkConfigurationDiagnostic(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters) {
        return getNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters).block();
    }

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkConfigurationDiagnosticResponseInner getNetworkConfigurationDiagnostic(
        String resourceGroupName,
        String networkWatcherName,
        NetworkConfigurationDiagnosticParameters parameters,
        Context context) {
        return getNetworkConfigurationDiagnosticAsync(resourceGroupName, networkWatcherName, parameters, context)
            .block();
    }
}
