// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Verify client certificate revocation status. */
public final class ApplicationGatewayClientRevocationOptions
    extends ExpandableStringEnum<ApplicationGatewayClientRevocationOptions> {
    /** Static value None for ApplicationGatewayClientRevocationOptions. */
    public static final ApplicationGatewayClientRevocationOptions NONE = fromString("None");

    /** Static value OCSP for ApplicationGatewayClientRevocationOptions. */
    public static final ApplicationGatewayClientRevocationOptions OCSP = fromString("OCSP");

    /**
     * Creates or finds a ApplicationGatewayClientRevocationOptions from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ApplicationGatewayClientRevocationOptions.
     */
    @JsonCreator
    public static ApplicationGatewayClientRevocationOptions fromString(String name) {
        return fromString(name, ApplicationGatewayClientRevocationOptions.class);
    }

    /**
     * Gets known ApplicationGatewayClientRevocationOptions values.
     *
     * @return known ApplicationGatewayClientRevocationOptions values.
     */
    public static Collection<ApplicationGatewayClientRevocationOptions> values() {
        return values(ApplicationGatewayClientRevocationOptions.class);
    }
}
