// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The DDoS protection mode of the public IP. */
public final class DdosSettingsProtectionMode extends ExpandableStringEnum<DdosSettingsProtectionMode> {
    /** Static value VirtualNetworkInherited for DdosSettingsProtectionMode. */
    public static final DdosSettingsProtectionMode VIRTUAL_NETWORK_INHERITED = fromString("VirtualNetworkInherited");

    /** Static value Enabled for DdosSettingsProtectionMode. */
    public static final DdosSettingsProtectionMode ENABLED = fromString("Enabled");

    /** Static value Disabled for DdosSettingsProtectionMode. */
    public static final DdosSettingsProtectionMode DISABLED = fromString("Disabled");

    /**
     * Creates or finds a DdosSettingsProtectionMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DdosSettingsProtectionMode.
     */
    @JsonCreator
    public static DdosSettingsProtectionMode fromString(String name) {
        return fromString(name, DdosSettingsProtectionMode.class);
    }

    /**
     * Gets known DdosSettingsProtectionMode values.
     *
     * @return known DdosSettingsProtectionMode values.
     */
    public static Collection<DdosSettingsProtectionMode> values() {
        return values(DdosSettingsProtectionMode.class);
    }
}
