// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Match condition to apply RouteMap rules. */
public final class RouteMapMatchCondition extends ExpandableStringEnum<RouteMapMatchCondition> {
    /** Static value Unknown for RouteMapMatchCondition. */
    public static final RouteMapMatchCondition UNKNOWN = fromString("Unknown");

    /** Static value Contains for RouteMapMatchCondition. */
    public static final RouteMapMatchCondition CONTAINS = fromString("Contains");

    /** Static value Equals for RouteMapMatchCondition. */
    public static final RouteMapMatchCondition EQUALS = fromString("Equals");

    /** Static value NotContains for RouteMapMatchCondition. */
    public static final RouteMapMatchCondition NOT_CONTAINS = fromString("NotContains");

    /** Static value NotEquals for RouteMapMatchCondition. */
    public static final RouteMapMatchCondition NOT_EQUALS = fromString("NotEquals");

    /**
     * Creates or finds a RouteMapMatchCondition from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RouteMapMatchCondition.
     */
    @JsonCreator
    public static RouteMapMatchCondition fromString(String name) {
        return fromString(name, RouteMapMatchCondition.class);
    }

    /**
     * Gets known RouteMapMatchCondition values.
     *
     * @return known RouteMapMatchCondition values.
     */
    public static Collection<RouteMapMatchCondition> values() {
        return values(RouteMapMatchCondition.class);
    }
}
