// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.SecurityAdminConfigurationInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A list of network manager security admin configurations. */
@Fluent
public final class SecurityAdminConfigurationListResult {
    /*
     * Gets a page of security admin configurations
     */
    @JsonProperty(value = "value")
    private List<SecurityAdminConfigurationInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of SecurityAdminConfigurationListResult class. */
    public SecurityAdminConfigurationListResult() {
    }

    /**
     * Get the value property: Gets a page of security admin configurations.
     *
     * @return the value value.
     */
    public List<SecurityAdminConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of security admin configurations.
     *
     * @param value the value value to set.
     * @return the SecurityAdminConfigurationListResult object itself.
     */
    public SecurityAdminConfigurationListResult withValue(List<SecurityAdminConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the SecurityAdminConfigurationListResult object itself.
     */
    public SecurityAdminConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
