// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network. */
@Fluent
public final class SubnetListResult {
    /*
     * The subnets in a virtual network.
     */
    @JsonProperty(value = "value")
    private List<SubnetInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of SubnetListResult class. */
    public SubnetListResult() {
    }

    /**
     * Get the value property: The subnets in a virtual network.
     *
     * @return the value value.
     */
    public List<SubnetInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The subnets in a virtual network.
     *
     * @param value the value value to set.
     * @return the SubnetListResult object itself.
     */
    public SubnetListResult withValue(List<SubnetInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the SubnetListResult object itself.
     */
    public SubnetListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
