// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Vpn NatRule mapping. */
@Fluent
public final class VpnNatRuleMapping {
    /*
     * Address space for Vpn NatRule mapping.
     */
    @JsonProperty(value = "addressSpace")
    private String addressSpace;

    /*
     * Port range for Vpn NatRule mapping.
     */
    @JsonProperty(value = "portRange")
    private String portRange;

    /** Creates an instance of VpnNatRuleMapping class. */
    public VpnNatRuleMapping() {
    }

    /**
     * Get the addressSpace property: Address space for Vpn NatRule mapping.
     *
     * @return the addressSpace value.
     */
    public String addressSpace() {
        return this.addressSpace;
    }

    /**
     * Set the addressSpace property: Address space for Vpn NatRule mapping.
     *
     * @param addressSpace the addressSpace value to set.
     * @return the VpnNatRuleMapping object itself.
     */
    public VpnNatRuleMapping withAddressSpace(String addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    /**
     * Get the portRange property: Port range for Vpn NatRule mapping.
     *
     * @return the portRange value.
     */
    public String portRange() {
        return this.portRange;
    }

    /**
     * Set the portRange property: Port range for Vpn NatRule mapping.
     *
     * @param portRange the portRange value to set.
     * @return the VpnNatRuleMapping object itself.
     */
    public VpnNatRuleMapping withPortRange(String portRange) {
        this.portRange = portRange;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
