// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resourcegraph.models.Facet;
import com.azure.resourcemanager.resourcegraph.models.ResultTruncated;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Query result. */
@Fluent
public final class QueryResponseInner {
    /*
     * Number of total records matching the query.
     */
    @JsonProperty(value = "totalRecords", required = true)
    private long totalRecords;

    /*
     * Number of records returned in the current response. In the case of paging, this is the number of records in the
     * current page.
     */
    @JsonProperty(value = "count", required = true)
    private long count;

    /*
     * Indicates whether the query results are truncated.
     */
    @JsonProperty(value = "resultTruncated", required = true)
    private ResultTruncated resultTruncated;

    /*
     * When present, the value can be passed to a subsequent query call (together with the same query and scopes used
     * in the current request) to retrieve the next page of data.
     */
    @JsonProperty(value = "$skipToken")
    private String skipToken;

    /*
     * Query output in JObject array or Table format.
     */
    @JsonProperty(value = "data", required = true)
    private Object data;

    /*
     * Query facets.
     */
    @JsonProperty(value = "facets")
    private List<Facet> facets;

    /** Creates an instance of QueryResponseInner class. */
    public QueryResponseInner() {
    }

    /**
     * Get the totalRecords property: Number of total records matching the query.
     *
     * @return the totalRecords value.
     */
    public long totalRecords() {
        return this.totalRecords;
    }

    /**
     * Set the totalRecords property: Number of total records matching the query.
     *
     * @param totalRecords the totalRecords value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
        return this;
    }

    /**
     * Get the count property: Number of records returned in the current response. In the case of paging, this is the
     * number of records in the current page.
     *
     * @return the count value.
     */
    public long count() {
        return this.count;
    }

    /**
     * Set the count property: Number of records returned in the current response. In the case of paging, this is the
     * number of records in the current page.
     *
     * @param count the count value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withCount(long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the resultTruncated property: Indicates whether the query results are truncated.
     *
     * @return the resultTruncated value.
     */
    public ResultTruncated resultTruncated() {
        return this.resultTruncated;
    }

    /**
     * Set the resultTruncated property: Indicates whether the query results are truncated.
     *
     * @param resultTruncated the resultTruncated value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withResultTruncated(ResultTruncated resultTruncated) {
        this.resultTruncated = resultTruncated;
        return this;
    }

    /**
     * Get the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     *
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     *
     * @param skipToken the skipToken value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Get the data property: Query output in JObject array or Table format.
     *
     * @return the data value.
     */
    public Object data() {
        return this.data;
    }

    /**
     * Set the data property: Query output in JObject array or Table format.
     *
     * @param data the data value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withData(Object data) {
        this.data = data;
        return this;
    }

    /**
     * Get the facets property: Query facets.
     *
     * @return the facets value.
     */
    public List<Facet> facets() {
        return this.facets;
    }

    /**
     * Set the facets property: Query facets.
     *
     * @param facets the facets value to set.
     * @return the QueryResponseInner object itself.
     */
    public QueryResponseInner withFacets(List<Facet> facets) {
        this.facets = facets;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resultTruncated() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property resultTruncated in model QueryResponseInner"));
        }
        if (data() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property data in model QueryResponseInner"));
        }
        if (facets() != null) {
            facets().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(QueryResponseInner.class);
}
