// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resourcegraph.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The options for query evaluation. */
@Fluent
public final class QueryRequestOptions {
    /*
     * Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
     */
    @JsonProperty(value = "$skipToken")
    private String skipToken;

    /*
     * The maximum number of rows that the query should return. Overrides the page size when ```$skipToken``` property
     * is present.
     */
    @JsonProperty(value = "$top")
    private Integer top;

    /*
     * The number of rows to skip from the beginning of the results. Overrides the next page offset when
     * ```$skipToken``` property is present.
     */
    @JsonProperty(value = "$skip")
    private Integer skip;

    /*
     * Defines in which format query result returned.
     */
    @JsonProperty(value = "resultFormat")
    private ResultFormat resultFormat;

    /*
     * Only applicable for tenant and management group level queries to decide whether to allow partial scopes for
     * result in case the number of subscriptions exceed allowed limits.
     */
    @JsonProperty(value = "allowPartialScopes")
    private Boolean allowPartialScopes;

    /** Creates an instance of QueryRequestOptions class. */
    public QueryRequestOptions() {
    }

    /**
     * Get the skipToken property: Continuation token for pagination, capturing the next page size and offset, as well
     * as the context of the query.
     *
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: Continuation token for pagination, capturing the next page size and offset, as well
     * as the context of the query.
     *
     * @param skipToken the skipToken value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Get the top property: The maximum number of rows that the query should return. Overrides the page size when
     * ```$skipToken``` property is present.
     *
     * @return the top value.
     */
    public Integer top() {
        return this.top;
    }

    /**
     * Set the top property: The maximum number of rows that the query should return. Overrides the page size when
     * ```$skipToken``` property is present.
     *
     * @param top the top value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withTop(Integer top) {
        this.top = top;
        return this;
    }

    /**
     * Get the skip property: The number of rows to skip from the beginning of the results. Overrides the next page
     * offset when ```$skipToken``` property is present.
     *
     * @return the skip value.
     */
    public Integer skip() {
        return this.skip;
    }

    /**
     * Set the skip property: The number of rows to skip from the beginning of the results. Overrides the next page
     * offset when ```$skipToken``` property is present.
     *
     * @param skip the skip value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    /**
     * Get the resultFormat property: Defines in which format query result returned.
     *
     * @return the resultFormat value.
     */
    public ResultFormat resultFormat() {
        return this.resultFormat;
    }

    /**
     * Set the resultFormat property: Defines in which format query result returned.
     *
     * @param resultFormat the resultFormat value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    /**
     * Get the allowPartialScopes property: Only applicable for tenant and management group level queries to decide
     * whether to allow partial scopes for result in case the number of subscriptions exceed allowed limits.
     *
     * @return the allowPartialScopes value.
     */
    public Boolean allowPartialScopes() {
        return this.allowPartialScopes;
    }

    /**
     * Set the allowPartialScopes property: Only applicable for tenant and management group level queries to decide
     * whether to allow partial scopes for result in case the number of subscriptions exceed allowed limits.
     *
     * @param allowPartialScopes the allowPartialScopes value to set.
     * @return the QueryRequestOptions object itself.
     */
    public QueryRequestOptions withAllowPartialScopes(Boolean allowPartialScopes) {
        this.allowPartialScopes = allowPartialScopes;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
