// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.models.AvailabilityZonePeers;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of the Check zone peers operation. */
@Fluent
public final class CheckZonePeersResultInner {
    /*
     * The subscription ID.
     */
    @JsonProperty(value = "subscriptionId", access = JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;

    /*
     * the location of the subscription.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The Availability Zones shared by the subscriptions.
     */
    @JsonProperty(value = "availabilityZonePeers")
    private List<AvailabilityZonePeers> availabilityZonePeers;

    /**
     * Get the subscriptionId property: The subscription ID.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the location property: the location of the subscription.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: the location of the subscription.
     *
     * @param location the location value to set.
     * @return the CheckZonePeersResultInner object itself.
     */
    public CheckZonePeersResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the availabilityZonePeers property: The Availability Zones shared by the subscriptions.
     *
     * @return the availabilityZonePeers value.
     */
    public List<AvailabilityZonePeers> availabilityZonePeers() {
        return this.availabilityZonePeers;
    }

    /**
     * Set the availabilityZonePeers property: The Availability Zones shared by the subscriptions.
     *
     * @param availabilityZonePeers the availabilityZonePeers value to set.
     * @return the CheckZonePeersResultInner object itself.
     */
    public CheckZonePeersResultInner withAvailabilityZonePeers(List<AvailabilityZonePeers> availabilityZonePeers) {
        this.availabilityZonePeers = availabilityZonePeers;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (availabilityZonePeers() != null) {
            availabilityZonePeers().forEach(e -> e.validate());
        }
    }
}
