// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.search.fluent.models.PrivateLinkResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response containing a list of supported Private Link Resources. */
@Immutable
public final class PrivateLinkResourcesResult {
    /*
     * The list of supported Private Link Resources.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateLinkResourceInner> value;

    /**
     * Get the value property: The list of supported Private Link Resources.
     *
     * @return the value value.
     */
    public List<PrivateLinkResourceInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
