/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.fluent.models;

import com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SearchServiceProperties {
    @JsonProperty(value="replicaCount")
    private Integer replicaCount;
    @JsonProperty(value="partitionCount")
    private Integer partitionCount;
    @JsonProperty(value="hostingMode")
    private HostingMode hostingMode;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private SearchServiceStatus status;
    @JsonProperty(value="statusDetails", access=JsonProperty.Access.WRITE_ONLY)
    private String statusDetails;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="networkRuleSet")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="sharedPrivateLinkResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources;

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public SearchServiceProperties withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public SearchServiceProperties withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public HostingMode hostingMode() {
        return this.hostingMode;
    }

    public SearchServiceProperties withHostingMode(HostingMode hostingMode) {
        this.hostingMode = hostingMode;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SearchServiceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public SearchServiceStatus status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public SearchServiceProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    public void validate() {
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.sharedPrivateLinkResources() != null) {
            this.sharedPrivateLinkResources().forEach(e -> e.validate());
        }
    }
}

