// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties supplied for Subnet. */
@Fluent
public final class Subnet {
    /*
     * Resource ID of Virtual Network Subnet
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * Get the id property: Resource ID of Virtual Network Subnet.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID of Virtual Network Subnet.
     *
     * @param id the id value to set.
     * @return the Subnet object itself.
     */
    public Subnet withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property id in model Subnet"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Subnet.class);
}
