/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.apt;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class AnnotationProcessingUtils {
    private AnnotationProcessingUtils() {
    }

    public static Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> getAnnotationElement(AnnotationMirror annotation, String member) {
        return AnnotationProcessingUtils.getAnnotationElement(null, annotation, member);
    }

    public static Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> getAnnotationElement(ProcessingEnvironment processEnv, AnnotationMirror annotation, String member) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationElementValues = null;
        annotationElementValues = processEnv != null ? processEnv.getElementUtils().getElementValuesWithDefaults(annotation) : annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationElementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(member)) continue;
            return entry;
        }
        return null;
    }

    public static AnnotationValue getAnnotationElementValue(AnnotationMirror annotation, String member) {
        return AnnotationProcessingUtils.getAnnotationElementValue(null, annotation, member);
    }

    public static AnnotationValue getAnnotationElementValue(ProcessingEnvironment processEnv, AnnotationMirror annotation, String member) {
        Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = AnnotationProcessingUtils.getAnnotationElement(processEnv, annotation, member);
        return entry == null ? null : entry.getValue();
    }

    public static AnnotationMirror findAnnotationMirror(Element element, TypeElement annotationTypeElement) {
        return AnnotationProcessingUtils.findAnnotationMirror(element, annotationTypeElement.getQualifiedName().toString());
    }

    public static AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        return AnnotationProcessingUtils.findAnnotationMirror(element, annotation.getName());
    }

    public static AnnotationMirror findAnnotationMirror(Element element, String qualifiedAnnotationName) {
        return AnnotationProcessingUtils.findAnnotationMirror(null, element, qualifiedAnnotationName);
    }

    public static AnnotationMirror findAnnotationMirror(ProcessingEnvironment processEnv, Element element, TypeElement annotationTypeElement) {
        return AnnotationProcessingUtils.findAnnotationMirror(processEnv, element, annotationTypeElement.getQualifiedName().toString());
    }

    public static AnnotationMirror findAnnotationMirror(ProcessingEnvironment processEnv, Element element, Class<? extends Annotation> annotation) {
        return AnnotationProcessingUtils.findAnnotationMirror(processEnv, element, annotation.getName());
    }

    public static AnnotationMirror findAnnotationMirror(ProcessingEnvironment processEnv, Element element, String qualifiedAnnotationName) {
        List<? extends AnnotationMirror> annotationMirrors = null;
        annotationMirrors = processEnv != null ? processEnv.getElementUtils().getAllAnnotationMirrors(element) : element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(qualifiedAnnotationName)) continue;
            return annotationMirror;
        }
        return null;
    }
}

