/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;

public class ApproximateNumericOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final ApproximateNumericOperatorInterpreter INSTANCE = new ApproximateNumericOperatorInterpreter();

    private ApproximateNumericOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        Comparable r;
        Comparable l;
        if (leftValue == null || rightValue == null) {
            return null;
        }
        if (leftValue instanceof Double && rightValue instanceof Long) {
            l = (Comparable)leftValue;
            r = Double.valueOf(((Long)rightValue).doubleValue());
        } else if (leftValue instanceof Long && rightValue instanceof Double) {
            l = Double.valueOf(((Long)leftValue).doubleValue());
            r = (Comparable)rightValue;
        } else {
            l = (Comparable)leftValue;
            r = (Comparable)rightValue;
        }
        switch (operator) {
            case EQUAL: {
                return l.compareTo(r) == 0;
            }
            case NOT_EQUAL: {
                return l.compareTo(r) != 0;
            }
            case GREATER_OR_EQUAL: {
                return l.compareTo(r) > -1;
            }
            case GREATER: {
                return l.compareTo(r) > 0;
            }
            case LOWER_OR_EQUAL: {
                return l.compareTo(r) < 1;
            }
            case LOWER: {
                return l.compareTo(r) < 0;
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (rightValue == null) {
            if (leftValue == null) {
                return null;
            }
            if (operator == DomainOperator.UNARY_MINUS) {
                if (leftValue instanceof Double) {
                    return -((Double)leftValue).doubleValue();
                }
                if (leftValue instanceof Long) {
                    return -((Long)leftValue).longValue();
                }
            }
        } else {
            if (leftValue == null) {
                return null;
            }
            if (rightValue instanceof String) {
                return leftValue + rightValue.toString();
            }
            if (leftValue instanceof Long && rightValue instanceof Long) {
                long l = (Long)leftValue;
                long r = (Long)rightValue;
                switch (operator) {
                    case PLUS: {
                        return l + r;
                    }
                    case MINUS: {
                        return l - r;
                    }
                    case MULTIPLICATION: {
                        return l * r;
                    }
                    case DIVISION: {
                        return l / r;
                    }
                    case MODULO: {
                        return l % r;
                    }
                }
            } else {
                double r;
                double l;
                if (leftValue instanceof Double && rightValue instanceof Long) {
                    l = (Double)leftValue;
                    r = ((Long)rightValue).doubleValue();
                } else if (leftValue instanceof Long && rightValue instanceof Double) {
                    l = ((Long)leftValue).doubleValue();
                    r = (Double)rightValue;
                } else if (leftValue instanceof Double && rightValue instanceof Double) {
                    l = (Double)leftValue;
                    r = (Double)rightValue;
                } else {
                    throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
                }
                switch (operator) {
                    case PLUS: {
                        return l + r;
                    }
                    case MINUS: {
                        return l - r;
                    }
                    case MULTIPLICATION: {
                        return l * r;
                    }
                    case DIVISION: {
                        return l / r;
                    }
                    case MODULO: {
                        return l % r;
                    }
                }
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

