/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.boot.model.MetadataDefinitionHolder;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainOperationTypeResolver;
import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainPredicate;
import com.blazebit.domain.runtime.model.DomainPredicateTypeResolver;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.DomainTypeResolverException;
import com.blazebit.domain.runtime.model.EnumDomainTypeValue;
import com.blazebit.domain.runtime.model.StaticDomainOperationTypeResolvers;
import com.blazebit.domain.runtime.model.StaticDomainPredicateTypeResolvers;
import com.blazebit.domain.runtime.model.TemporalInterval;
import com.blazebit.domain.spi.DomainContributor;
import com.blazebit.domain.spi.DomainSerializer;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionCompiler;
import com.blazebit.expression.ExpressionService;
import com.blazebit.expression.ExpressionServiceBuilder;
import com.blazebit.expression.base.ApproximateNumericOperatorInterpreter;
import com.blazebit.expression.base.BooleanOperatorInterpreter;
import com.blazebit.expression.base.DateOperatorInterpreter;
import com.blazebit.expression.base.ExactNumericOperatorInterpreter;
import com.blazebit.expression.base.IntervalOperatorInterpreter;
import com.blazebit.expression.base.StringOperatorInterpreter;
import com.blazebit.expression.base.StringlyTypeHandler;
import com.blazebit.expression.base.TimeOperatorInterpreter;
import com.blazebit.expression.base.TimestampOperatorInterpreter;
import com.blazebit.expression.base.function.AbsFunction;
import com.blazebit.expression.base.function.Atan2Function;
import com.blazebit.expression.base.function.CeilFunction;
import com.blazebit.expression.base.function.CurrentDateFunction;
import com.blazebit.expression.base.function.CurrentTimeFunction;
import com.blazebit.expression.base.function.CurrentTimestampFunction;
import com.blazebit.expression.base.function.EndsWithFunction;
import com.blazebit.expression.base.function.FloorFunction;
import com.blazebit.expression.base.function.GreatestFunction;
import com.blazebit.expression.base.function.LTrimFunction;
import com.blazebit.expression.base.function.LeastFunction;
import com.blazebit.expression.base.function.LengthFunction;
import com.blazebit.expression.base.function.LocateFunction;
import com.blazebit.expression.base.function.LocateLastFunction;
import com.blazebit.expression.base.function.LowerFunction;
import com.blazebit.expression.base.function.NumericFunction;
import com.blazebit.expression.base.function.PowFunction;
import com.blazebit.expression.base.function.RTrimFunction;
import com.blazebit.expression.base.function.RandomFunction;
import com.blazebit.expression.base.function.ReplaceFunction;
import com.blazebit.expression.base.function.RoundFunction;
import com.blazebit.expression.base.function.SizeFunction;
import com.blazebit.expression.base.function.StartsWithFunction;
import com.blazebit.expression.base.function.SubstringFunction;
import com.blazebit.expression.base.function.TrimFunction;
import com.blazebit.expression.base.function.UpperFunction;
import com.blazebit.expression.spi.BooleanLiteralResolver;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DefaultResolvedLiteral;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import com.blazebit.expression.spi.EnumLiteralResolver;
import com.blazebit.expression.spi.ExpressionServiceContributor;
import com.blazebit.expression.spi.ExpressionServiceSerializer;
import com.blazebit.expression.spi.NumericLiteralResolver;
import com.blazebit.expression.spi.ResolvedLiteral;
import com.blazebit.expression.spi.StringLiteralResolver;
import com.blazebit.expression.spi.TemporalLiteralResolver;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseContributor
implements DomainContributor,
ExpressionServiceContributor {
    public static final String CONFIGURATION_NUMERIC_EXACT = "numeric.exact";
    public static final String CONFIGURATION_NUMERIC_SCALE = "numeric.scale";
    public static final int DEFAULT_NUMERIC_SCALE = 5;
    public static final String CONFIGURATION_NUMERIC_ROUNDING = "numeric.rounding";
    public static final RoundingMode DEFAULT_NUMERIC_ROUNDING = RoundingMode.HALF_UP;
    public static final String BOOLEAN_TYPE_NAME = "Boolean";
    public static final String INTEGER_TYPE_NAME = "Integer";
    public static final String NUMERIC_TYPE_NAME = "Numeric";
    public static final String TIMESTAMP_TYPE_NAME = "Timestamp";
    public static final Class<?> TIME = LocalTime.class;
    public static final String TIME_TYPE_NAME = "Time";
    public static final String INTERVAL_TYPE_NAME = "Interval";
    public static final String STRING_TYPE_NAME = "String";
    public static final String DATE_TYPE_NAME = "Date";
    public static final String INTEGER_OR_NUMERIC_TYPE_NAME = "Integer|Numeric";
    public static final BooleanLiteralResolver BOOLEAN_LITERAL_TYPE_RESOLVER = new BooleanLiteralResolverImpl();
    public static final NumericLiteralResolver NUMERIC_LITERAL_TYPE_RESOLVER = new NumericLiteralResolverImpl();
    public static final TemporalLiteralResolver TEMPORAL_LITERAL_TYPE_RESOLVER = new TemporalLiteralResolverImpl();
    public static final StringLiteralResolver STRING_LITERAL_TYPE_RESOLVER = new StringLiteralResolverImpl();
    public static final EnumLiteralResolver ENUM_LITERAL_RESOLVER = new EnumLiteralResolverImpl();

    public void contribute(ExpressionServiceBuilder expressionServiceBuilder) {
        expressionServiceBuilder.withNumericLiteralResolver(NUMERIC_LITERAL_TYPE_RESOLVER);
        expressionServiceBuilder.withStringLiteralResolver(STRING_LITERAL_TYPE_RESOLVER);
        expressionServiceBuilder.withTemporalLiteralResolver(TEMPORAL_LITERAL_TYPE_RESOLVER);
        expressionServiceBuilder.withBooleanLiteralResolver(BOOLEAN_LITERAL_TYPE_RESOLVER);
        expressionServiceBuilder.withEnumLiteralResolver(ENUM_LITERAL_RESOLVER);
    }

    public void contribute(DomainBuilder domainBuilder) {
        Object numericExact = domainBuilder.getProperty(CONFIGURATION_NUMERIC_EXACT);
        if (numericExact == null || ((Boolean)numericExact).booleanValue()) {
            BaseContributor.createBasicType(domainBuilder, BigInteger.class, INTEGER_TYPE_NAME, DomainOperator.arithmetic(), DomainPredicate.comparable(), this.handlersFor(ExactNumericOperatorInterpreter.INSTANCE, "INTEGER"));
            BaseContributor.createBasicType(domainBuilder, BigDecimal.class, NUMERIC_TYPE_NAME, DomainOperator.arithmetic(), DomainPredicate.comparable(), this.handlersFor(ExactNumericOperatorInterpreter.INSTANCE, "NUMERIC"));
        } else {
            BaseContributor.createBasicType(domainBuilder, Long.class, INTEGER_TYPE_NAME, DomainOperator.arithmetic(), DomainPredicate.comparable(), this.handlersFor(ApproximateNumericOperatorInterpreter.INSTANCE, "INTEGER"));
            BaseContributor.createBasicType(domainBuilder, Double.class, NUMERIC_TYPE_NAME, DomainOperator.arithmetic(), DomainPredicate.comparable(), this.handlersFor(ApproximateNumericOperatorInterpreter.INSTANCE, "NUMERIC"));
        }
        BaseContributor.createBasicType(domainBuilder, String.class, STRING_TYPE_NAME, new DomainOperator[]{DomainOperator.PLUS}, DomainPredicate.comparable(), this.handlersFor(StringOperatorInterpreter.INSTANCE, "STRING"));
        BaseContributor.createBasicType(domainBuilder, Instant.class, TIMESTAMP_TYPE_NAME, new DomainOperator[]{DomainOperator.PLUS, DomainOperator.MINUS}, DomainPredicate.comparable(), this.handlersFor(TimestampOperatorInterpreter.INSTANCE, "TIMESTAMP"));
        BaseContributor.createBasicType(domainBuilder, LocalTime.class, TIME_TYPE_NAME, new DomainOperator[]{DomainOperator.PLUS, DomainOperator.MINUS}, DomainPredicate.comparable(), this.handlersFor(TimeOperatorInterpreter.INSTANCE, "TIME"));
        BaseContributor.createBasicType(domainBuilder, LocalDate.class, DATE_TYPE_NAME, new DomainOperator[]{DomainOperator.PLUS, DomainOperator.MINUS}, DomainPredicate.comparable(), this.handlersFor(DateOperatorInterpreter.INSTANCE, "DATE"));
        BaseContributor.createBasicType(domainBuilder, TemporalInterval.class, INTERVAL_TYPE_NAME, new DomainOperator[]{DomainOperator.PLUS, DomainOperator.MINUS}, DomainPredicate.comparable(), this.handlersFor(IntervalOperatorInterpreter.INSTANCE, "INTERVAL"));
        BaseContributor.createBasicType(domainBuilder, Boolean.class, BOOLEAN_TYPE_NAME, new DomainOperator[]{DomainOperator.NOT}, DomainPredicate.distinguishable(), this.handlersFor(BooleanOperatorInterpreter.INSTANCE, "BOOLEAN"));
        for (String type : Arrays.asList(INTEGER_TYPE_NAME, NUMERIC_TYPE_NAME)) {
            domainBuilder.withOperationTypeResolver(type, DomainOperator.MODULO, StaticDomainOperationTypeResolvers.widest((String[])new String[]{NUMERIC_TYPE_NAME, INTEGER_TYPE_NAME}));
            domainBuilder.withOperationTypeResolver(type, DomainOperator.UNARY_MINUS, StaticDomainOperationTypeResolvers.returning((String)type));
            domainBuilder.withOperationTypeResolver(type, DomainOperator.UNARY_PLUS, StaticDomainOperationTypeResolvers.returning((String)type));
            domainBuilder.withOperationTypeResolver(type, DomainOperator.DIVISION, StaticDomainOperationTypeResolvers.returning((String)NUMERIC_TYPE_NAME, (String[])new String[]{INTEGER_TYPE_NAME, NUMERIC_TYPE_NAME}));
            for (DomainOperator domainOperator : Arrays.asList(DomainOperator.MINUS, DomainOperator.MULTIPLICATION)) {
                domainBuilder.withOperationTypeResolver(type, domainOperator, StaticDomainOperationTypeResolvers.widest((String[])new String[]{NUMERIC_TYPE_NAME, INTEGER_TYPE_NAME}));
            }
            domainBuilder.withOperationTypeResolver(type, DomainOperator.PLUS, StaticDomainOperationTypeResolvers.widest((String[])new String[]{STRING_TYPE_NAME, NUMERIC_TYPE_NAME, INTEGER_TYPE_NAME}));
            BaseContributor.withPredicateTypeResolvers(domainBuilder, type, INTEGER_TYPE_NAME, NUMERIC_TYPE_NAME);
        }
        domainBuilder.withOperationTypeResolver(STRING_TYPE_NAME, DomainOperator.PLUS, (DomainOperationTypeResolver)new StringlyDomainOperationTypeResolver(STRING_TYPE_NAME, STRING_TYPE_NAME, INTEGER_TYPE_NAME, NUMERIC_TYPE_NAME));
        StringlyDomainPredicateTypeResolver stringlyDomainPredicateTypeResolver = new StringlyDomainPredicateTypeResolver(BOOLEAN_TYPE_NAME, STRING_TYPE_NAME);
        for (DomainPredicate domainPredicate : domainBuilder.getEnabledPredicates(domainBuilder.getType(STRING_TYPE_NAME).getName())) {
            domainBuilder.withPredicateTypeResolver(STRING_TYPE_NAME, domainPredicate, (DomainPredicateTypeResolver)stringlyDomainPredicateTypeResolver);
        }
        domainBuilder.withDefaultPredicateResultType(BOOLEAN_TYPE_NAME);
        domainBuilder.withOperationTypeResolver(BOOLEAN_TYPE_NAME, DomainOperator.NOT, StaticDomainOperationTypeResolvers.returning((String)BOOLEAN_TYPE_NAME));
        BaseContributor.withPredicateTypeResolvers(domainBuilder, BOOLEAN_TYPE_NAME, BOOLEAN_TYPE_NAME);
        domainBuilder.withOperationTypeResolver(TIMESTAMP_TYPE_NAME, DomainOperator.PLUS, StaticDomainOperationTypeResolvers.returning((String)TIMESTAMP_TYPE_NAME, (String[][])new String[][]{{TIMESTAMP_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        domainBuilder.withOperationTypeResolver(TIMESTAMP_TYPE_NAME, DomainOperator.MINUS, StaticDomainOperationTypeResolvers.returning((String)TIMESTAMP_TYPE_NAME, (String[][])new String[][]{{TIMESTAMP_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        BaseContributor.withPredicateTypeResolvers(domainBuilder, TIMESTAMP_TYPE_NAME, TIMESTAMP_TYPE_NAME);
        domainBuilder.withOperationTypeResolver(TIME_TYPE_NAME, DomainOperator.PLUS, StaticDomainOperationTypeResolvers.returning((String)TIME_TYPE_NAME, (String[][])new String[][]{{TIME_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        domainBuilder.withOperationTypeResolver(TIME_TYPE_NAME, DomainOperator.MINUS, StaticDomainOperationTypeResolvers.returning((String)TIME_TYPE_NAME, (String[][])new String[][]{{TIME_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        BaseContributor.withPredicateTypeResolvers(domainBuilder, TIME_TYPE_NAME, TIME_TYPE_NAME);
        domainBuilder.withOperationTypeResolver(DATE_TYPE_NAME, DomainOperator.PLUS, StaticDomainOperationTypeResolvers.returning((String)DATE_TYPE_NAME, (String[][])new String[][]{{DATE_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        domainBuilder.withOperationTypeResolver(DATE_TYPE_NAME, DomainOperator.MINUS, StaticDomainOperationTypeResolvers.returning((String)DATE_TYPE_NAME, (String[][])new String[][]{{DATE_TYPE_NAME}, {INTERVAL_TYPE_NAME}}));
        BaseContributor.withPredicateTypeResolvers(domainBuilder, DATE_TYPE_NAME, DATE_TYPE_NAME);
        domainBuilder.withOperationTypeResolver(INTERVAL_TYPE_NAME, DomainOperator.PLUS, StaticDomainOperationTypeResolvers.widest((String[])new String[]{TIMESTAMP_TYPE_NAME, TIME_TYPE_NAME, INTERVAL_TYPE_NAME}));
        domainBuilder.withOperationTypeResolver(INTERVAL_TYPE_NAME, DomainOperator.MINUS, StaticDomainOperationTypeResolvers.widest((String[])new String[]{TIMESTAMP_TYPE_NAME, TIME_TYPE_NAME, INTERVAL_TYPE_NAME}));
        BaseContributor.withPredicateTypeResolvers(domainBuilder, INTERVAL_TYPE_NAME, INTERVAL_TYPE_NAME);
        CurrentTimestampFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        CurrentDateFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        CurrentTimeFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        SubstringFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        ReplaceFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        TrimFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LTrimFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        RTrimFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        UpperFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LowerFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LengthFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LocateFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LocateLastFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        StartsWithFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        EndsWithFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        AbsFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        CeilFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        FloorFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        NumericFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        Atan2Function.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        RoundFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        RandomFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        PowFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        GreatestFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        LeastFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
        SizeFunction.addFunction(domainBuilder, BaseContributor.class.getClassLoader());
    }

    public int priority() {
        return 500;
    }

    private static void withPredicateTypeResolvers(DomainBuilder domainBuilder, String type, String ... supportedTypes) {
        Set enabledPredicates = domainBuilder.getEnabledPredicates(domainBuilder.getType(type).getName());
        if (!enabledPredicates.isEmpty()) {
            DomainPredicateTypeResolver predicateTypeResolver = StaticDomainPredicateTypeResolvers.returning((String)BOOLEAN_TYPE_NAME, (String[])supportedTypes);
            for (DomainPredicate domainPredicate : enabledPredicates) {
                domainBuilder.withPredicateTypeResolver(type, domainPredicate, predicateTypeResolver);
            }
        }
    }

    private <T extends ComparisonOperatorInterpreter & DomainOperatorInterpreter> MetadataDefinition<?>[] handlersFor(T instance, String documentationKey) {
        return new MetadataDefinition[]{new ComparisonOperatorInterpreterMetadataDefinition(instance), new DomainOperatorInterpreterMetadataDefinition(instance), DocumentationMetadataDefinition.localized((String)documentationKey, (ClassLoader)BaseContributor.class.getClassLoader())};
    }

    private static void createBasicType(DomainBuilder domainBuilder, Class<?> type, String name, DomainOperator[] operators, DomainPredicate[] predicates, MetadataDefinition<?> ... metadataDefinitions) {
        domainBuilder.createBasicType(name, type, metadataDefinitions);
        domainBuilder.withOperator(name, operators);
        domainBuilder.withPredicate(name, predicates);
    }

    private static class StringlyDomainPredicateTypeResolver
    implements DomainPredicateTypeResolver,
    DomainSerializer<DomainPredicateTypeResolver>,
    Serializable {
        private final String returningType;
        private final Set<String> supportedTypeNames;

        public StringlyDomainPredicateTypeResolver(String returningType, String ... supportedTypeNames) {
            this.returningType = returningType;
            this.supportedTypeNames = new HashSet<String>(Arrays.asList(supportedTypeNames));
        }

        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                DomainType domainType = domainTypes.get(i);
                if (this.supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(this.supportedTypeNames.size());
                for (String typeName : this.supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                if (domainType.getMetadata(StringlyTypeHandler.class) != null) continue;
                throw new DomainTypeResolverException("The predicate operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following types: " + types);
            }
            return domainModel.getType(this.returningType);
        }

        public <T> T serialize(DomainModel domainModel, DomainPredicateTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"RestrictedDomainPredicateTypeResolver\":[");
            sb.append('\"').append(domainModel.getType(this.returningType).getName()).append("\",[");
            for (DomainType domainType : domainModel.getTypes().values()) {
                String typeName = domainType.getName();
                if (!this.supportedTypeNames.contains(typeName) && domainType.getMetadata(StringlyTypeHandler.class) == null) continue;
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }

    private static class StringlyDomainOperationTypeResolver
    implements DomainOperationTypeResolver,
    DomainSerializer<DomainOperationTypeResolver>,
    Serializable {
        private final String returningType;
        private final Set<String> supportedTypeNames;

        public StringlyDomainOperationTypeResolver(String returningType, String ... supportedTypeNames) {
            this.returningType = returningType;
            this.supportedTypeNames = new HashSet<String>(Arrays.asList(supportedTypeNames));
        }

        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                DomainType domainType = domainTypes.get(i);
                if (this.supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(this.supportedTypeNames.size());
                for (String typeName : this.supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                if (domainType.getMetadata(StringlyTypeHandler.class) != null) continue;
                throw new DomainTypeResolverException("The operation operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following: " + types);
            }
            return domainModel.getType(this.returningType);
        }

        public <T> T serialize(DomainModel domainModel, DomainOperationTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"RestrictedDomainOperationTypeResolver\":[");
            sb.append('\"').append(this.returningType).append("\",[");
            for (DomainType domainType : domainModel.getTypes().values()) {
                String typeName = domainType.getName();
                if (!this.supportedTypeNames.contains(typeName) && domainType.getMetadata(StringlyTypeHandler.class) == null) continue;
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }

    static class DomainOperatorInterpreterMetadataDefinition
    implements MetadataDefinition<DomainOperatorInterpreter> {
        private final DomainOperatorInterpreter domainOperatorInterpreter;

        public DomainOperatorInterpreterMetadataDefinition(DomainOperatorInterpreter domainOperatorInterpreter) {
            this.domainOperatorInterpreter = domainOperatorInterpreter;
        }

        public Class<DomainOperatorInterpreter> getJavaType() {
            return DomainOperatorInterpreter.class;
        }

        public DomainOperatorInterpreter build(MetadataDefinitionHolder definitionHolder) {
            return this.domainOperatorInterpreter;
        }
    }

    static class ComparisonOperatorInterpreterMetadataDefinition
    implements MetadataDefinition<ComparisonOperatorInterpreter>,
    Serializable {
        private final ComparisonOperatorInterpreter comparisonOperatorInterpreter;

        public ComparisonOperatorInterpreterMetadataDefinition(ComparisonOperatorInterpreter comparisonOperatorInterpreter) {
            this.comparisonOperatorInterpreter = comparisonOperatorInterpreter;
        }

        public Class<ComparisonOperatorInterpreter> getJavaType() {
            return ComparisonOperatorInterpreter.class;
        }

        public ComparisonOperatorInterpreter build(MetadataDefinitionHolder definitionHolder) {
            return this.comparisonOperatorInterpreter;
        }
    }

    private static class EnumLiteralResolverImpl
    implements ExpressionServiceSerializer<EnumLiteralResolver>,
    EnumLiteralResolver,
    Serializable {
        private EnumLiteralResolverImpl() {
        }

        public <T> T serialize(ExpressionService expressionService, EnumLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)"\"SimpleEnumLiteralResolver\"";
        }

        public ResolvedLiteral resolveLiteral(ExpressionCompiler.Context context, EnumDomainTypeValue value) {
            return new DefaultResolvedLiteral((DomainType)value.getOwner(), (Object)value);
        }
    }

    private static class StringLiteralResolverImpl
    implements ExpressionServiceSerializer<StringLiteralResolver>,
    StringLiteralResolver,
    Serializable {
        private StringLiteralResolverImpl() {
        }

        public <T> T serialize(ExpressionService expressionService, StringLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)"\"StringLiteralResolver\"";
        }

        public ResolvedLiteral resolveLiteral(ExpressionCompiler.Context context, String value) {
            return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.STRING_TYPE_NAME), (Object)value);
        }
    }

    private static class TemporalLiteralResolverImpl
    implements ExpressionServiceSerializer<TemporalLiteralResolver>,
    TemporalLiteralResolver,
    Serializable {
        private TemporalLiteralResolverImpl() {
        }

        public <T> T serialize(ExpressionService expressionService, TemporalLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)"\"TemporalLiteralResolver\"";
        }

        public ResolvedLiteral resolveTimestampLiteral(ExpressionCompiler.Context context, Instant value) {
            return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.TIMESTAMP_TYPE_NAME), (Object)value);
        }

        public ResolvedLiteral resolveIntervalLiteral(ExpressionCompiler.Context context, TemporalInterval value) {
            return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.INTERVAL_TYPE_NAME), (Object)value);
        }
    }

    private static class NumericLiteralResolverImpl
    implements ExpressionServiceSerializer<NumericLiteralResolver>,
    NumericLiteralResolver,
    Serializable {
        private NumericLiteralResolverImpl() {
        }

        public <T> T serialize(ExpressionService expressionService, NumericLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)"\"NumericLiteralResolver\"";
        }

        public ResolvedLiteral resolveLiteral(ExpressionCompiler.Context context, Number value) {
            if (value instanceof BigDecimal || value instanceof Double) {
                return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.NUMERIC_TYPE_NAME), (Object)value);
            }
            return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.INTEGER_TYPE_NAME), (Object)value);
        }
    }

    private static class BooleanLiteralResolverImpl
    implements ExpressionServiceSerializer<BooleanLiteralResolver>,
    BooleanLiteralResolver,
    Serializable {
        private BooleanLiteralResolverImpl() {
        }

        public <T> T serialize(ExpressionService expressionService, BooleanLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)"\"BooleanLiteralResolver\"";
        }

        public ResolvedLiteral resolveLiteral(ExpressionCompiler.Context context, boolean value) {
            return new DefaultResolvedLiteral(context.getExpressionService().getDomainModel().getType(BaseContributor.BOOLEAN_TYPE_NAME), (Object)value);
        }
    }
}

