/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;

public class BooleanOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final BooleanOperatorInterpreter INSTANCE = new BooleanOperatorInterpreter();

    private BooleanOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        if (leftValue instanceof Boolean && rightValue instanceof Boolean) {
            boolean l = (Boolean)leftValue;
            boolean r = (Boolean)rightValue;
            switch (operator) {
                case EQUAL: {
                    return l == r;
                }
                case NOT_EQUAL: {
                    return l != r;
                }
            }
        } else {
            throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (operator == DomainOperator.NOT) {
            return (Boolean)leftValue == false;
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

