/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.TemporalInterval;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;
import java.time.LocalDate;

public class DateOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final DateOperatorInterpreter INSTANCE = new DateOperatorInterpreter();

    private DateOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        if (leftValue instanceof LocalDate && rightValue instanceof LocalDate) {
            LocalDate l = (LocalDate)leftValue;
            LocalDate r = (LocalDate)rightValue;
            switch (operator) {
                case EQUAL: {
                    return l.compareTo(r) == 0;
                }
                case NOT_EQUAL: {
                    return l.compareTo(r) != 0;
                }
                case GREATER_OR_EQUAL: {
                    return l.compareTo(r) > -1;
                }
                case GREATER: {
                    return l.compareTo(r) > 0;
                }
                case LOWER_OR_EQUAL: {
                    return l.compareTo(r) < 1;
                }
                case LOWER: {
                    return l.compareTo(r) < 0;
                }
            }
        } else {
            throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (leftValue instanceof TemporalInterval && rightValue instanceof TemporalInterval) {
            TemporalInterval interval1 = (TemporalInterval)leftValue;
            TemporalInterval interval2 = (TemporalInterval)rightValue;
            switch (operator) {
                case PLUS: {
                    return interval1.add(interval2);
                }
                case MINUS: {
                    return interval1.subtract(interval2);
                }
            }
        } else if (leftValue instanceof LocalDate && rightValue instanceof TemporalInterval) {
            LocalDate localDate = (LocalDate)leftValue;
            TemporalInterval interval = (TemporalInterval)rightValue;
            switch (operator) {
                case PLUS: {
                    return interval.add(localDate);
                }
                case MINUS: {
                    return interval.subtract(localDate);
                }
            }
        } else if (leftValue instanceof TemporalInterval && rightValue instanceof LocalDate) {
            TemporalInterval interval = (TemporalInterval)leftValue;
            LocalDate localDate = (LocalDate)rightValue;
            if (operator == DomainOperator.PLUS) {
                return interval.add(localDate);
            }
        } else {
            throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

