/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.BaseContributor;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ExactNumericOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final ExactNumericOperatorInterpreter INSTANCE = new ExactNumericOperatorInterpreter();

    private ExactNumericOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        Comparable r;
        Comparable l;
        if (leftValue == null || rightValue == null) {
            return null;
        }
        if (leftValue instanceof BigDecimal && rightValue instanceof BigInteger) {
            l = (Comparable)leftValue;
            r = new BigDecimal((BigInteger)rightValue);
        } else if (leftValue instanceof BigInteger && rightValue instanceof BigDecimal) {
            l = new BigDecimal((BigInteger)leftValue);
            r = (Comparable)rightValue;
        } else {
            l = (Comparable)leftValue;
            r = (Comparable)rightValue;
        }
        switch (operator) {
            case EQUAL: {
                return l.compareTo(r) == 0;
            }
            case NOT_EQUAL: {
                return l.compareTo(r) != 0;
            }
            case GREATER_OR_EQUAL: {
                return l.compareTo(r) > -1;
            }
            case GREATER: {
                return l.compareTo(r) > 0;
            }
            case LOWER_OR_EQUAL: {
                return l.compareTo(r) < 1;
            }
            case LOWER: {
                return l.compareTo(r) < 0;
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (rightValue == null) {
            if (leftValue == null) {
                return null;
            }
            if (operator == DomainOperator.UNARY_MINUS) {
                if (leftValue instanceof BigDecimal) {
                    return ((BigDecimal)leftValue).negate();
                }
                if (leftValue instanceof BigInteger) {
                    return ((BigInteger)leftValue).negate();
                }
            }
        } else {
            if (leftValue == null) {
                return null;
            }
            if (rightValue instanceof String) {
                return leftValue + rightValue.toString();
            }
            if (leftValue instanceof BigInteger && rightValue instanceof BigInteger) {
                BigInteger l = (BigInteger)leftValue;
                BigInteger r = (BigInteger)rightValue;
                switch (operator) {
                    case PLUS: {
                        return l.add(r);
                    }
                    case MINUS: {
                        return l.subtract(r);
                    }
                    case MULTIPLICATION: {
                        return l.multiply(r);
                    }
                    case DIVISION: {
                        return l.divide(r);
                    }
                    case MODULO: {
                        return l.remainder(r);
                    }
                }
            } else {
                BigDecimal r;
                BigDecimal l;
                if (leftValue instanceof BigDecimal && rightValue instanceof BigInteger) {
                    l = (BigDecimal)leftValue;
                    r = new BigDecimal((BigInteger)rightValue);
                } else if (leftValue instanceof BigInteger && rightValue instanceof BigDecimal) {
                    l = new BigDecimal((BigInteger)leftValue);
                    r = (BigDecimal)rightValue;
                } else if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
                    l = (BigDecimal)leftValue;
                    r = (BigDecimal)rightValue;
                } else {
                    throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
                }
                switch (operator) {
                    case PLUS: {
                        return l.add(r);
                    }
                    case MINUS: {
                        return l.subtract(r);
                    }
                    case MULTIPLICATION: {
                        return l.multiply(r);
                    }
                    case DIVISION: {
                        Object scaleValue = context.getProperty("numeric.scale");
                        int scale = scaleValue == null ? 5 : (Integer)scaleValue;
                        Object roundingValue = context.getProperty("numeric.rounding");
                        RoundingMode roundingMode = roundingValue == null ? BaseContributor.DEFAULT_NUMERIC_ROUNDING : (RoundingMode)((Object)roundingValue);
                        return l.divide(r, scale, roundingMode);
                    }
                    case MODULO: {
                        return l.remainder(r);
                    }
                }
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

