/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.TemporalInterval;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalTime;

public class IntervalOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final IntervalOperatorInterpreter INSTANCE = new IntervalOperatorInterpreter();

    private IntervalOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        if (leftValue instanceof TemporalInterval && rightValue instanceof TemporalInterval) {
            TemporalInterval l = (TemporalInterval)leftValue;
            TemporalInterval r = (TemporalInterval)rightValue;
            switch (operator) {
                case EQUAL: {
                    return l.compareTo(r) == 0;
                }
                case NOT_EQUAL: {
                    return l.compareTo(r) != 0;
                }
                case GREATER_OR_EQUAL: {
                    return l.compareTo(r) > -1;
                }
                case GREATER: {
                    return l.compareTo(r) > 0;
                }
                case LOWER_OR_EQUAL: {
                    return l.compareTo(r) < 1;
                }
                case LOWER: {
                    return l.compareTo(r) < 0;
                }
            }
        } else {
            throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (leftValue instanceof TemporalInterval && rightValue instanceof TemporalInterval) {
            TemporalInterval interval1 = (TemporalInterval)leftValue;
            TemporalInterval interval2 = (TemporalInterval)rightValue;
            switch (operator) {
                case PLUS: {
                    return interval1.add(interval2);
                }
                case MINUS: {
                    return interval1.subtract(interval2);
                }
            }
        } else if (rightValue instanceof TemporalInterval) {
            if (leftValue instanceof Instant) {
                Instant instant = (Instant)leftValue;
                TemporalInterval interval = (TemporalInterval)rightValue;
                switch (operator) {
                    case PLUS: {
                        return interval.add(instant);
                    }
                    case MINUS: {
                        return interval.subtract(instant);
                    }
                }
            } else if (leftValue instanceof LocalTime) {
                LocalTime localTime = (LocalTime)leftValue;
                TemporalInterval interval = (TemporalInterval)rightValue;
                switch (operator) {
                    case PLUS: {
                        return interval.add(localTime);
                    }
                    case MINUS: {
                        return interval.subtract(localTime);
                    }
                }
            }
        } else if (leftValue instanceof TemporalInterval) {
            if (rightValue instanceof Instant) {
                TemporalInterval interval = (TemporalInterval)leftValue;
                Instant instant = (Instant)rightValue;
                if (operator == DomainOperator.PLUS) {
                    return interval.add(instant);
                }
            } else if (rightValue instanceof LocalTime) {
                TemporalInterval interval = (TemporalInterval)leftValue;
                LocalTime localTime = (LocalTime)rightValue;
                if (operator == DomainOperator.PLUS) {
                    return interval.add(localTime);
                }
            }
        } else {
            throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

