/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.StringlyTypeHandler;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import com.blazebit.expression.spi.DomainOperatorInterpreter;
import java.io.Serializable;

public class StringOperatorInterpreter
implements ComparisonOperatorInterpreter,
DomainOperatorInterpreter,
Serializable {
    public static final StringOperatorInterpreter INSTANCE = new StringOperatorInterpreter();

    private StringOperatorInterpreter() {
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        String r;
        String l;
        if (leftValue instanceof String && rightValue instanceof String) {
            l = (String)leftValue;
            r = (String)rightValue;
        } else {
            StringlyTypeHandler stringlyTypeHandler = (StringlyTypeHandler)rightType.getMetadata(StringlyTypeHandler.class);
            if (stringlyTypeHandler == null) {
                throw new DomainModelException("Illegal arguments [" + leftValue + ", " + rightValue + "]!");
            }
            l = (String)leftValue;
            r = stringlyTypeHandler.destruct(rightValue);
        }
        switch (operator) {
            case EQUAL: {
                return l.compareTo(r) == 0;
            }
            case NOT_EQUAL: {
                return l.compareTo(r) != 0;
            }
            case GREATER_OR_EQUAL: {
                return l.compareTo(r) > -1;
            }
            case GREATER: {
                return l.compareTo(r) > 0;
            }
            case LOWER_OR_EQUAL: {
                return l.compareTo(r) < 1;
            }
            case LOWER: {
                return l.compareTo(r) < 0;
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }

    public Object interpret(ExpressionInterpreter.Context context, DomainType targetType, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, DomainOperator operator) {
        if (operator == DomainOperator.PLUS) {
            StringlyTypeHandler stringlyTypeHandler = (StringlyTypeHandler)rightType.getMetadata(StringlyTypeHandler.class);
            if (stringlyTypeHandler == null) {
                return leftValue.toString().concat(rightValue.toString());
            }
            return leftValue.toString().concat(stringlyTypeHandler.destruct(rightValue));
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

