/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.StringlyTypeHandler;
import com.blazebit.expression.spi.ComparisonOperatorInterpreter;
import java.io.Serializable;

public class StringlyOperatorInterpreter
implements ComparisonOperatorInterpreter,
Serializable {
    private final StringlyTypeHandler<Object> handler;

    public StringlyOperatorInterpreter(StringlyTypeHandler<?> handler) {
        this.handler = handler;
    }

    public Boolean interpret(ExpressionInterpreter.Context context, DomainType leftType, DomainType rightType, Object leftValue, Object rightValue, ComparisonOperator operator) {
        Object referenceValue = leftType == rightType ? leftValue : this.handler.destruct(leftValue);
        switch (operator) {
            case EQUAL: {
                return referenceValue.equals(rightValue);
            }
            case NOT_EQUAL: {
                return !referenceValue.equals(rightValue);
            }
        }
        throw new DomainModelException("Can't handle the operator " + operator + " for the arguments [" + leftValue + ", " + rightValue + "]!");
    }
}

