/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base;

import com.blazebit.domain.boot.model.BasicDomainTypeDefinition;
import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.DomainFunctionBuilder;
import com.blazebit.domain.boot.model.DomainFunctionDefinition;
import com.blazebit.domain.boot.model.DomainTypeDefinition;
import com.blazebit.domain.boot.model.EnumDomainTypeBuilder;
import com.blazebit.domain.boot.model.EnumDomainTypeDefinition;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.DomainPredicate;
import com.blazebit.domain.runtime.model.StaticDomainPredicateTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.base.BaseContributor;
import com.blazebit.expression.base.EnumValueStringlyTypeAdapter;
import com.blazebit.expression.base.GlobalStringlyTypeDestructorFunctionInvoker;
import com.blazebit.expression.base.StringlyOperatorInterpreter;
import com.blazebit.expression.base.StringlyTypeConstructorFunctionInvoker;
import com.blazebit.expression.base.StringlyTypeDestructorFunctionInvoker;
import com.blazebit.expression.base.StringlyTypeHandler;
import com.blazebit.expression.base.StringlyTypeHandlerMetadataDefinition;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.FunctionInvoker;

public class StringlyTypeUtils {
    public static final String DEFAULT_GLOBAL_DESTRUCTOR_NAME = "TO_STRING";
    public static final String DEFAULT_DESTRUCTOR_DOCUMENTATION_KEY = "TO_STRING";
    public static final String DEFAULT_DESTRUCTOR_ARGUMENT_DOCUMENTATION_KEY = "TO_STRING_VALUE";
    public static final String DEFAULT_CONSTRUCTOR_DOCUMENTATION_KEY = "CONSTRUCTOR";

    private StringlyTypeUtils() {
    }

    public static void registerGlobalStringlyTypeDestructor(DomainBuilder domainBuilder, String typeName, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerGlobalStringlyTypeDestructor(domainBuilder, typeName, "TO_STRING", "TO_STRING", DEFAULT_DESTRUCTOR_ARGUMENT_DOCUMENTATION_KEY, stringlyTypeHandler.getClass().getClassLoader(), stringlyTypeHandler);
    }

    public static void registerGlobalStringlyTypeDestructor(DomainBuilder domainBuilder, String typeName, String destructorName, String destructorDocumentationKey, String destructorArgumentDocumentationKey, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerGlobalStringlyTypeDestructor(domainBuilder, typeName, destructorName, destructorDocumentationKey, destructorArgumentDocumentationKey, stringlyTypeHandler.getClass().getClassLoader(), stringlyTypeHandler);
    }

    public static void registerGlobalStringlyTypeDestructor(DomainBuilder domainBuilder, String typeName, String destructorName, String destructorDocumentationKey, String destructorArgumentDocumentationKey, ClassLoader resourceBundleClassLoader, StringlyTypeHandler<?> stringlyTypeHandler) {
        GlobalStringlyTypeDestructorFunctionInvoker handler;
        DomainFunctionDefinition function = domainBuilder.getFunction(destructorName);
        if (function == null) {
            MetadataDefinition[] destructorArgumentMetadata = destructorArgumentDocumentationKey == null ? new MetadataDefinition[]{} : new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)destructorArgumentDocumentationKey, (ClassLoader)resourceBundleClassLoader)};
            handler = new GlobalStringlyTypeDestructorFunctionInvoker(destructorName);
            DomainFunctionBuilder functionBuilder = domainBuilder.createFunction(destructorName).withArgument("value", destructorArgumentMetadata).withResultType("String").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(handler));
            if (destructorDocumentationKey != null) {
                functionBuilder.withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)destructorDocumentationKey, (ClassLoader)resourceBundleClassLoader));
            }
            functionBuilder.build();
        } else {
            handler = (GlobalStringlyTypeDestructorFunctionInvoker)((FunctionInvokerMetadataDefinition)function.getMetadataDefinitions().get(FunctionInvoker.class)).build(null);
        }
        handler.destructors.put(typeName, stringlyTypeHandler);
    }

    public static void registerSimpleStringlyType(DomainBuilder domainBuilder, String name) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, null, null, null, null, null, null, null, false, string -> string);
    }

    public static void registerSimpleStringlyType(DomainBuilder domainBuilder, String name, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, null, null, null, null, null, null, null, false, stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, DEFAULT_CONSTRUCTOR_DOCUMENTATION_KEY, "TO_STRING", string -> string);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, DEFAULT_CONSTRUCTOR_DOCUMENTATION_KEY, "TO_STRING", stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, ClassLoader resourceBundleClassLoader, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, resourceBundleClassLoader, DEFAULT_CONSTRUCTOR_DOCUMENTATION_KEY, "TO_STRING", stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, String constructorDocumentationKey, String destructorDocumentationKey, StringlyTypeHandler<?> stringlyTypeHandler) {
        String upperName = name.toUpperCase();
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, upperName, upperName + "_TO_STRING", stringlyTypeHandler.getClass().getClassLoader(), constructorDocumentationKey, constructorDocumentationKey == null ? null : constructorDocumentationKey + "_VALUE", destructorDocumentationKey, destructorDocumentationKey == null ? null : destructorDocumentationKey + "_VALUE", true, stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, ClassLoader resourceBundleClassLoader, String constructorDocumentationKey, String destructorDocumentationKey, StringlyTypeHandler<?> stringlyTypeHandler) {
        String upperName = name.toUpperCase();
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, upperName, upperName + "_TO_STRING", resourceBundleClassLoader, constructorDocumentationKey, constructorDocumentationKey == null ? null : constructorDocumentationKey + "_VALUE", destructorDocumentationKey, destructorDocumentationKey == null ? null : destructorDocumentationKey + "_VALUE", true, stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, String constructorName, String destructorName, String constructorDocumentationKey, String destructorDocumentationKey, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, constructorName, destructorName, stringlyTypeHandler.getClass().getClassLoader(), constructorDocumentationKey, constructorDocumentationKey == null ? null : constructorDocumentationKey + "_VALUE", destructorDocumentationKey, destructorDocumentationKey == null ? null : destructorDocumentationKey + "_VALUE", true, stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, String constructorName, String destructorName, ClassLoader resourceBundleClassLoader, String constructorDocumentationKey, String destructorDocumentationKey, StringlyTypeHandler<?> stringlyTypeHandler) {
        StringlyTypeUtils.registerStringlyType(domainBuilder, name, constructorName, destructorName, resourceBundleClassLoader, constructorDocumentationKey, constructorDocumentationKey == null ? null : constructorDocumentationKey + "_VALUE", destructorDocumentationKey, destructorDocumentationKey == null ? null : destructorDocumentationKey + "_VALUE", true, stringlyTypeHandler);
    }

    public static void registerStringlyType(DomainBuilder domainBuilder, String name, String constructorName, String destructorName, ClassLoader resourceBundleClassLoader, String constructorDocumentationKey, String constructorArgumentDocumentationKey, String destructorDocumentationKey, String destructorArgumentDocumentationKey, boolean registerGlobalDestructor, StringlyTypeHandler<?> stringlyTypeHandler) {
        DomainTypeDefinition type = domainBuilder.getType(name);
        if (type == null) {
            throw new IllegalArgumentException("Type does not exist yet: " + name);
        }
        StringlyTypeHandlerMetadataDefinition definition = (StringlyTypeHandlerMetadataDefinition)type.getMetadataDefinitions().get(StringlyTypeHandler.class);
        if (definition != null && definition.build(null) == stringlyTypeHandler) {
            return;
        }
        if (registerGlobalDestructor) {
            StringlyTypeUtils.registerGlobalStringlyTypeDestructor(domainBuilder, name, stringlyTypeHandler);
        }
        if (type instanceof BasicDomainTypeDefinition) {
            domainBuilder.extendBasicType(name, new MetadataDefinition[]{new BaseContributor.ComparisonOperatorInterpreterMetadataDefinition(new StringlyOperatorInterpreter(stringlyTypeHandler)), new StringlyTypeHandlerMetadataDefinition(stringlyTypeHandler)});
        } else if (type instanceof EnumDomainTypeDefinition) {
            EnumDomainTypeBuilder enumDomainTypeBuilder = domainBuilder.extendEnumType(name, (EnumDomainTypeDefinition)type);
            enumDomainTypeBuilder.withMetadata((MetadataDefinition)new BaseContributor.ComparisonOperatorInterpreterMetadataDefinition(new StringlyOperatorInterpreter(stringlyTypeHandler)));
            enumDomainTypeBuilder.withMetadata((MetadataDefinition)new StringlyTypeHandlerMetadataDefinition(stringlyTypeHandler));
            enumDomainTypeBuilder.withMetadata(new EnumValueStringlyTypeAdapter(stringlyTypeHandler));
            enumDomainTypeBuilder.build();
        } else {
            throw new IllegalArgumentException("Can't register stringly type handlers for non-basic and non-enum type: " + type);
        }
        domainBuilder.withOperationTypeResolver(name, DomainOperator.PLUS, domainBuilder.getOperationTypeResolver("String", DomainOperator.PLUS));
        domainBuilder.withOperator(name, DomainOperator.PLUS);
        domainBuilder.withPredicateTypeResolver(name, DomainPredicate.EQUALITY, StaticDomainPredicateTypeResolvers.returning((String)"Boolean", (String[])new String[]{name, "String"}));
        domainBuilder.withPredicate(name, DomainPredicate.distinguishable());
        if (type instanceof BasicDomainTypeDefinition && constructorName != null) {
            StringlyTypeConstructorFunctionInvoker constructorHandler = new StringlyTypeConstructorFunctionInvoker(stringlyTypeHandler);
            MetadataDefinition[] constructorArgumentMetadata = constructorArgumentDocumentationKey == null ? new MetadataDefinition[]{} : new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)constructorArgumentDocumentationKey, (ClassLoader)resourceBundleClassLoader)};
            DomainFunctionBuilder functionBuilder = domainBuilder.createFunction(constructorName).withArgument("value", "String", constructorArgumentMetadata).withResultType(name).withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(constructorHandler));
            if (constructorDocumentationKey != null) {
                functionBuilder.withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)constructorDocumentationKey, (ClassLoader)resourceBundleClassLoader));
            }
            functionBuilder.build();
        }
        if (destructorName != null && !registerGlobalDestructor) {
            FunctionInvokerMetadataDefinition metadataDefinition;
            DomainFunctionDefinition existingFunction = domainBuilder.getFunction(destructorName);
            FunctionInvokerMetadataDefinition functionInvokerMetadataDefinition = metadataDefinition = existingFunction == null ? null : (FunctionInvokerMetadataDefinition)existingFunction.getMetadataDefinitions().get(FunctionInvoker.class);
            if (metadataDefinition != null && metadataDefinition.build(null) instanceof GlobalStringlyTypeDestructorFunctionInvoker) {
                throw new IllegalStateException("Can't register a destructor for stringly type '" + name + "' under the function name '" + destructorName + "' as a global destructor is already registered under this name!");
            }
            MetadataDefinition[] destructorArgumentMetadata = destructorArgumentDocumentationKey == null ? new MetadataDefinition[]{} : new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)destructorArgumentDocumentationKey, (ClassLoader)resourceBundleClassLoader)};
            StringlyTypeDestructorFunctionInvoker destructorHandler = new StringlyTypeDestructorFunctionInvoker(stringlyTypeHandler);
            DomainFunctionBuilder functionBuilder = domainBuilder.createFunction(destructorName).withArgument("value", name, destructorArgumentMetadata).withResultType("String").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(destructorHandler));
            if (destructorDocumentationKey != null) {
                functionBuilder.withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)destructorDocumentationKey, (ClassLoader)resourceBundleClassLoader));
            }
            functionBuilder.build();
        }
    }
}

