/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AbsFunction
implements FunctionInvoker,
Serializable {
    private static final AbsFunction INSTANCE = new AbsFunction();

    private AbsFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("ABS").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"ABS", (ClassLoader)classLoader)).withExactArgumentCount(1).withArgument("number", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"ABS_ARG", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("ABS", StaticDomainFunctionTypeResolvers.FIRST_ARGUMENT_TYPE);
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object argument = arguments.getValue(0);
        if (argument == null) {
            return null;
        }
        if (argument instanceof BigDecimal) {
            return ((BigDecimal)argument).abs();
        }
        if (argument instanceof BigInteger) {
            return ((BigInteger)argument).abs();
        }
        if (argument instanceof Double) {
            return Math.abs((Double)argument);
        }
        if (argument instanceof Long) {
            return Math.abs((Long)argument);
        }
        throw new DomainModelException("Illegal argument for ABS function: " + argument);
    }
}

