/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;

public class Atan2Function
implements FunctionInvoker,
Serializable {
    private final boolean exact;

    private Atan2Function(boolean exact) {
        this.exact = exact;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("ATAN2").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(new Atan2Function(domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class))).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"ATAN2", (ClassLoader)classLoader)).withArgument("y", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"ATAN2_Y", (ClassLoader)classLoader)}).withArgument("x", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"ATAN2_X", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("ATAN2", StaticDomainFunctionTypeResolvers.returning((String)"Numeric"));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object y = arguments.getValue(0);
        if (y == null) {
            return null;
        }
        Object x = arguments.getValue(1);
        if (x == null) {
            return null;
        }
        double result = Math.atan2(((Number)y).doubleValue(), ((Number)x).doubleValue());
        if (this.exact) {
            return BigDecimal.valueOf(result);
        }
        return result;
    }
}

