/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainFunctionVolatility;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.CurrentTimestampFunction;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.time.Instant;

public class CurrentDateFunction
implements FunctionInvoker,
Serializable {
    private static final CurrentDateFunction INSTANCE = new CurrentDateFunction();
    private static final int SECONDS_PER_DAY = 86400;

    private CurrentDateFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("CURRENT_DATE").withVolatility(DomainFunctionVolatility.STABLE).withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"CURRENT_DATE", (ClassLoader)classLoader)).withExactArgumentCount(0).withResultType("Timestamp").build();
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Instant instant = CurrentTimestampFunction.get(context);
        return Instant.ofEpochSecond(Math.floorDiv(instant.getEpochSecond(), 86400) * 86400L);
    }
}

