/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainFunctionVolatility;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.CurrentTimestampFunction;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalTime;

public class CurrentTimeFunction
implements FunctionInvoker,
Serializable {
    private static final CurrentTimeFunction INSTANCE = new CurrentTimeFunction();
    private static final long SECONDS_PER_DAY = 86400L;

    private CurrentTimeFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("CURRENT_TIME").withVolatility(DomainFunctionVolatility.STABLE).withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"CURRENT_TIME", (ClassLoader)classLoader)).withExactArgumentCount(0).withResultType("Time").build();
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Instant instant = CurrentTimestampFunction.get(context);
        return LocalTime.ofSecondOfDay(Math.floorMod(instant.getEpochSecond(), 86400L));
    }
}

