/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class FloorFunction
implements FunctionInvoker,
Serializable {
    private static final FloorFunction INSTANCE = new FloorFunction();

    private FloorFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("FLOOR").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"FLOOR", (ClassLoader)classLoader)).withExactArgumentCount(1).withArgument("number", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"FLOOR_ARG", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("FLOOR", StaticDomainFunctionTypeResolvers.returning((String)"Integer"));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object argument = arguments.getValue(0);
        if (argument == null) {
            return null;
        }
        if (argument instanceof BigInteger || argument instanceof Long) {
            return argument;
        }
        if (argument instanceof BigDecimal) {
            return ((BigDecimal)argument).setScale(0, RoundingMode.FLOOR).toBigInteger();
        }
        if (argument instanceof Double) {
            return Math.floor((Double)argument);
        }
        throw new DomainModelException("Illegal argument for CEIL function: " + argument);
    }
}

