/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.util.Collection;

public class GreatestFunction
implements FunctionInvoker,
Serializable {
    private static final GreatestFunction INSTANCE = new GreatestFunction();

    private GreatestFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("GREATEST").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"GREATEST", (ClassLoader)classLoader)).withMinArgumentCount(2).withArgument("first", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"GREATEST_FIRST", (ClassLoader)classLoader)}).withArgument("second", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"GREATEST_SECOND", (ClassLoader)classLoader)}).withArgument("other", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"GREATEST_OTHER", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("GREATEST", StaticDomainFunctionTypeResolvers.widest((String[])new String[]{"Numeric"}));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Comparable greatest = (Comparable)arguments.getValue(0);
        Object second = arguments.getValue(1);
        Collection other = (Collection)arguments.getValue(2);
        if (second != null && (greatest == null || greatest.compareTo(second) < 0)) {
            greatest = (Comparable)second;
        }
        if (other != null && !other.isEmpty()) {
            for (Object value : other) {
                if (value == null || greatest != null && greatest.compareTo(value) >= 0) continue;
                greatest = (Comparable)value;
            }
        }
        return greatest;
    }
}

