/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.util.Collection;

public class LeastFunction
implements FunctionInvoker,
Serializable {
    private static final LeastFunction INSTANCE = new LeastFunction();

    private LeastFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("LEAST").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"LEAST", (ClassLoader)classLoader)).withMinArgumentCount(2).withArgument("first", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LEAST_FIRST", (ClassLoader)classLoader)}).withArgument("second", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LEAST_SECOND", (ClassLoader)classLoader)}).withArgument("other", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LEAST_OTHER", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("LEAST", StaticDomainFunctionTypeResolvers.widest((String[])new String[]{"Numeric"}));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Comparable least = (Comparable)arguments.getValue(0);
        Object second = arguments.getValue(1);
        Collection other = (Collection)arguments.getValue(2);
        if (second != null && (least == null || least.compareTo(second) > 0)) {
            least = (Comparable)second;
        }
        if (other != null && !other.isEmpty()) {
            for (Object value : other) {
                if (value == null || least != null && least.compareTo(value) <= 0) continue;
                least = (Comparable)value;
            }
        }
        return least;
    }
}

