/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class LengthFunction
implements FunctionInvoker,
Serializable {
    private final boolean exact;

    private LengthFunction(boolean exact) {
        this.exact = exact;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("LENGTH").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(new LengthFunction(domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class))).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"LENGTH", (ClassLoader)classLoader)).withExactArgumentCount(1).withResultType("Integer").withArgument("string", "String", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LENGTH_STRING", (ClassLoader)classLoader)}).build();
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object string = arguments.getValue(0);
        if (string == null) {
            return null;
        }
        int length = string.toString().length();
        if (this.exact) {
            return BigInteger.valueOf(length);
        }
        return (long)length;
    }
}

