/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class LocateLastFunction
implements FunctionInvoker,
Serializable {
    private final boolean exact;

    private LocateLastFunction(boolean exact) {
        this.exact = exact;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("LOCATE_LAST").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(new LocateLastFunction(domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class))).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"LOCATE_LAST", (ClassLoader)classLoader)).withMinArgumentCount(2).withResultType("Integer").withArgument("substring", "String", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LOCATE_LAST_SUBSTRING", (ClassLoader)classLoader)}).withArgument("string", "String", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LOCATE_LAST_STRING", (ClassLoader)classLoader)}).withArgument("start", "Integer", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"LOCATE_LAST_START", (ClassLoader)classLoader)}).build();
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object substring = arguments.getValue(0);
        if (substring == null) {
            return null;
        }
        Object string = arguments.getValue(1);
        if (string == null) {
            return null;
        }
        Object start = arguments.getValue(2);
        if (start == null) {
            if (arguments.assignedArguments() < 3) {
                start = 0;
            } else {
                return null;
            }
        }
        String needle = substring.toString();
        String s = string.toString();
        int startIndex = ((Number)start).intValue();
        int index = s.lastIndexOf(needle, startIndex);
        if (this.exact) {
            return BigInteger.valueOf(index);
        }
        return (long)index;
    }
}

