/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public abstract class NumericFunction
implements FunctionInvoker,
Serializable {
    private final String name;

    private NumericFunction(String name) {
        this.name = name;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        boolean exact = domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class;
        List<NumericFunction> functions = exact ? Arrays.asList(new NumericFunction("SQRT"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.sqrt(value));
            }
        }, new NumericFunction("SIN"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.sin(value));
            }
        }, new NumericFunction("COS"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.cos(value));
            }
        }, new NumericFunction("TAN"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.tan(value));
            }
        }, new NumericFunction("ASIN"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.asin(value));
            }
        }, new NumericFunction("ACOS"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.acos(value));
            }
        }, new NumericFunction("ATAN"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.atan(value));
            }
        }, new NumericFunction("LOG"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.log(value));
            }
        }, new NumericFunction("EXP"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.exp(value));
            }
        }, new NumericFunction("RADIANS"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.toRadians(value));
            }
        }, new NumericFunction("DEGREES"){

            @Override
            protected Object invoke(double value) {
                return BigDecimal.valueOf(Math.toDegrees(value));
            }
        }) : Arrays.asList(new NumericFunction("SQRT"){

            @Override
            protected Object invoke(double value) {
                return Math.sqrt(value);
            }
        }, new NumericFunction("SIN"){

            @Override
            protected Object invoke(double value) {
                return Math.sin(value);
            }
        }, new NumericFunction("COS"){

            @Override
            protected Object invoke(double value) {
                return Math.cos(value);
            }
        }, new NumericFunction("TAN"){

            @Override
            protected Object invoke(double value) {
                return Math.tan(value);
            }
        }, new NumericFunction("ASIN"){

            @Override
            protected Object invoke(double value) {
                return Math.asin(value);
            }
        }, new NumericFunction("ACOS"){

            @Override
            protected Object invoke(double value) {
                return Math.acos(value);
            }
        }, new NumericFunction("ATAN"){

            @Override
            protected Object invoke(double value) {
                return Math.atan(value);
            }
        }, new NumericFunction("LOG"){

            @Override
            protected Object invoke(double value) {
                return Math.log(value);
            }
        }, new NumericFunction("EXP"){

            @Override
            protected Object invoke(double value) {
                return Math.exp(value);
            }
        }, new NumericFunction("RADIANS"){

            @Override
            protected Object invoke(double value) {
                return Math.toRadians(value);
            }
        }, new NumericFunction("DEGREES"){

            @Override
            protected Object invoke(double value) {
                return Math.toDegrees(value);
            }
        });
        for (NumericFunction f : functions) {
            domainBuilder.createFunction(f.name).withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(f)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)f.name, (ClassLoader)classLoader)).withExactArgumentCount(1).withArgument("number", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)(f.name + "_ARG"), (ClassLoader)classLoader)}).build();
            domainBuilder.withFunctionTypeResolver(f.name, StaticDomainFunctionTypeResolvers.returning((String)"Numeric"));
        }
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object argument = arguments.getValue(0);
        if (argument == null) {
            return null;
        }
        if (argument instanceof Number) {
            return this.invoke(((Number)argument).doubleValue());
        }
        throw new DomainModelException("Illegal argument for " + this.name + " function: " + argument);
    }

    protected abstract Object invoke(double var1);
}

