/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;

public class PowFunction
implements FunctionInvoker,
Serializable {
    private static final PowFunction INSTANCE = new PowFunction();

    private PowFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("POW").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"POW", (ClassLoader)classLoader)).withArgument("base", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"POW_BASE", (ClassLoader)classLoader)}).withArgument("power", "Integer|Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"POW_POWER", (ClassLoader)classLoader)}).build();
        domainBuilder.withFunctionTypeResolver("POW", StaticDomainFunctionTypeResolvers.returning((String)"Numeric"));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object base = arguments.getValue(0);
        if (base == null) {
            return null;
        }
        Object power = arguments.getValue(1);
        if (power == null) {
            return null;
        }
        return BigDecimal.valueOf(Math.pow(((Number)base).doubleValue(), ((Number)power).doubleValue()));
    }
}

