/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainFunctionVolatility;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;

public class RandomFunction
implements FunctionInvoker,
Serializable {
    private final boolean exact;

    private RandomFunction(boolean exact) {
        this.exact = exact;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("RANDOM").withVolatility(DomainFunctionVolatility.VOLATILE).withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(new RandomFunction(domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class))).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"RANDOM", (ClassLoader)classLoader)).build();
        domainBuilder.withFunctionTypeResolver("RANDOM", StaticDomainFunctionTypeResolvers.returning((String)"Numeric"));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        double value = ThreadLocalRandom.current().nextDouble();
        if (this.exact) {
            return BigDecimal.valueOf(value);
        }
        return value;
    }
}

