/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.StaticDomainFunctionTypeResolvers;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class RoundFunction
implements FunctionInvoker,
Serializable {
    private static final RoundFunction INSTANCE = new RoundFunction();

    private RoundFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("ROUND").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"ROUND", (ClassLoader)classLoader)).withArgument("value", "Numeric", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"ROUND_VALUE", (ClassLoader)classLoader)}).withArgument("precision", "Integer", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"ROUND_PRECISION", (ClassLoader)classLoader)}).withMinArgumentCount(1).build();
        domainBuilder.withFunctionTypeResolver("ROUND", StaticDomainFunctionTypeResolvers.returning((String)"Numeric"));
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object value = arguments.getValue(0);
        if (value == null) {
            return null;
        }
        int prec = 0;
        if (arguments.assignedArguments() > 1) {
            Object precision = arguments.getValue(1);
            if (precision == null) {
                return null;
            }
            prec = ((Number)precision).intValue();
        }
        return new BigDecimal(((Number)value).doubleValue()).round(new MathContext(prec, RoundingMode.HALF_UP));
    }
}

