/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.CollectionDomainType;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainFunctionArgument;
import com.blazebit.domain.runtime.model.DomainFunctionTypeResolver;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;

public class SizeFunction
implements FunctionInvoker,
DomainFunctionTypeResolver,
Serializable {
    private final boolean exact;

    private SizeFunction(boolean exact) {
        this.exact = exact;
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        SizeFunction sizeFunction = new SizeFunction(domainBuilder.getType("Numeric").getJavaType() == BigDecimal.class);
        domainBuilder.createFunction("SIZE").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(sizeFunction)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"SIZE", (ClassLoader)classLoader)).withExactArgumentCount(1).withCollectionArgument("collection", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"SIZE_ARG", (ClassLoader)classLoader)}).withResultType("Integer").build();
        domainBuilder.withFunctionTypeResolver("SIZE", (DomainFunctionTypeResolver)sizeFunction);
    }

    public DomainType resolveType(DomainModel domainModel, DomainFunction function, Map<DomainFunctionArgument, DomainType> argumentTypes) {
        DomainType argumentType = argumentTypes.values().iterator().next();
        if (!(argumentType instanceof CollectionDomainType)) {
            throw new DomainModelException("SIZE only accepts a collection argument! Invalid type given: " + argumentType);
        }
        return domainModel.getType("Integer");
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object argument = arguments.getValue(0);
        if (argument == null) {
            return null;
        }
        if (argument instanceof Collection) {
            int size = ((Collection)argument).size();
            if (this.exact) {
                return BigInteger.valueOf(size);
            }
            return (long)size;
        }
        throw new DomainModelException("Illegal argument for SIZE function: " + argument);
    }
}

