/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.base.function;

import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.expression.DocumentationMetadataDefinition;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.base.function.FunctionInvokerMetadataDefinition;
import com.blazebit.expression.spi.DomainFunctionArguments;
import com.blazebit.expression.spi.FunctionInvoker;
import java.io.Serializable;

public class SubstringFunction
implements FunctionInvoker,
Serializable {
    private static final SubstringFunction INSTANCE = new SubstringFunction();

    private SubstringFunction() {
    }

    public static void addFunction(DomainBuilder domainBuilder, ClassLoader classLoader) {
        domainBuilder.createFunction("SUBSTRING").withMetadata((MetadataDefinition)new FunctionInvokerMetadataDefinition(INSTANCE)).withMetadata((MetadataDefinition)DocumentationMetadataDefinition.localized((String)"SUBSTRING", (ClassLoader)classLoader)).withMinArgumentCount(2).withResultType("String").withArgument("string", "String", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"SUBSTRING_STRING", (ClassLoader)classLoader)}).withArgument("start", "Integer", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"SUBSTRING_START", (ClassLoader)classLoader)}).withArgument("count", "Integer", new MetadataDefinition[]{DocumentationMetadataDefinition.localized((String)"SUBSTRING_COUNT", (ClassLoader)classLoader)}).build();
    }

    public Object invoke(ExpressionInterpreter.Context context, DomainFunction function, DomainFunctionArguments arguments) {
        Object string = arguments.getValue(0);
        if (string == null) {
            return null;
        }
        Object start = arguments.getValue(1);
        if (start == null) {
            return null;
        }
        int startIndex = ((Number)start).intValue() - 1;
        int endIndexOffset = 0;
        if (startIndex < 0) {
            endIndexOffset = -startIndex;
            startIndex = 0;
        }
        String s = string.toString();
        Object count = arguments.getValue(2);
        int endIndex = count == null ? s.length() - endIndexOffset : startIndex + ((Number)count).intValue() - endIndexOffset;
        if (endIndex > s.length()) {
            endIndex = s.length();
        }
        return s.substring(startIndex, endIndex);
    }
}

