/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.ExpressionSerializer;
import com.blazebit.expression.ExpressionService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class PersistenceExpressionSerializerContext<T>
implements ExpressionSerializer.Context {
    private final ExpressionService expressionService;
    private final T aliasProviderContext;
    private final Map<String, Object> contextParameters;
    private final Map<String, String> aliases;
    private final Map<String, Function<T, String>> aliasProviders;

    public PersistenceExpressionSerializerContext(ExpressionService expressionService, T aliasProviderContext) {
        this(expressionService, aliasProviderContext, Collections.emptyMap());
    }

    public PersistenceExpressionSerializerContext(ExpressionService expressionService, T aliasProviderContext, Map<String, Function<T, String>> aliasProviders) {
        this.expressionService = expressionService;
        this.aliasProviderContext = aliasProviderContext;
        this.contextParameters = new HashMap<String, Object>();
        this.aliases = new HashMap<String, String>();
        this.aliasProviders = new HashMap<String, Function<T, String>>(aliasProviders);
    }

    public PersistenceExpressionSerializerContext<T> withContextParameter(String contextParameterName, Object value) {
        this.contextParameters.put(contextParameterName, value);
        return this;
    }

    public Map<String, Object> getContextParameters() {
        return this.contextParameters;
    }

    public PersistenceExpressionSerializerContext<T> withAlias(String rootAlias, String queryAlias) {
        this.aliases.put(rootAlias, queryAlias);
        return this;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public PersistenceExpressionSerializerContext<T> withAliasProvider(String rootAlias, Function<T, String> aliasProvider) {
        if (this.aliasProviderContext == null) {
            throw new IllegalStateException("No alias provider context set, so can't handle alias providers!");
        }
        this.aliasProviders.put(rootAlias, aliasProvider);
        return this;
    }

    public Map<String, Function<T, String>> getAliasProviders() {
        return this.aliasProviders;
    }

    public ExpressionInterpreter.Context getInterpreterContextForInlining() {
        return (ExpressionInterpreter.Context)this.contextParameters.get("persistence.constant_inlining_interpreter_context");
    }

    public void setInterpreterContextForInlining(ExpressionInterpreter.Context interpreterContextForInlining) {
        this.contextParameters.put("persistence.constant_inlining_interpreter_context", interpreterContextForInlining);
    }

    public Set<String> getPathsToInline() {
        return (Set)this.contextParameters.get("persistence.paths_to_inline");
    }

    public void setPathsToInline(Set<String> pathsToInline) {
        this.contextParameters.put("persistence.paths_to_inline", pathsToInline);
    }

    public ExpressionService getExpressionService() {
        return this.expressionService;
    }

    public <X> X getContextParameter(String contextParameterName) {
        String alias = this.aliases.get(contextParameterName);
        if (alias == null) {
            Function<T, String> provider = this.aliasProviders.get(contextParameterName);
            if (provider == null) {
                return (X)this.contextParameters.get(contextParameterName);
            }
            alias = provider.apply(this.aliasProviderContext);
            this.aliases.put(contextParameterName, alias);
        }
        return (X)alias;
    }
}

