/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.expression.ChainingArithmeticExpression;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.Expression;
import com.blazebit.expression.persistence.PersistenceDomainOperatorRenderer;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceStringlyTypeHandler;
import java.io.Serializable;

public class PersistenceStringOperatorRenderer
implements PersistenceDomainOperatorRenderer,
Serializable {
    public static final PersistenceStringOperatorRenderer INSTANCE = new PersistenceStringOperatorRenderer();

    private PersistenceStringOperatorRenderer() {
    }

    @Override
    public boolean render(ChainingArithmeticExpression e, PersistenceExpressionSerializer serializer) {
        if (e.getOperator().getDomainOperator() == DomainOperator.PLUS) {
            StringBuilder sb = serializer.getStringBuilder();
            PersistenceStringlyTypeHandler stringlyTypeHandler = (PersistenceStringlyTypeHandler)e.getRight().getType().getMetadata(PersistenceStringlyTypeHandler.class);
            sb.append("CONCAT(");
            boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)serializer);
            sb.append(", ");
            isConstant = stringlyTypeHandler == null ? (Boolean)e.getRight().accept((Expression.ResultVisitor)serializer) != false && isConstant : stringlyTypeHandler.appendPersistenceDestructTo(sb, stringBuilder -> {
                if (sb == stringBuilder) {
                    return (Boolean)e.getRight().accept((Expression.ResultVisitor)serializer);
                }
                int idx = sb.length();
                boolean constant = (Boolean)e.getRight().accept((Expression.ResultVisitor)serializer);
                stringBuilder.append(sb, idx, sb.length());
                sb.setLength(idx);
                return constant;
            }) && isConstant;
            sb.append(')');
            return isConstant;
        }
        throw new DomainModelException("Can't handle the operator " + e.getOperator().getDomainOperator() + " for the arguments [" + e.getLeft() + ", " + e.getRight() + "]!");
    }
}

