/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spi;

import com.blazebit.persistence.spi.JpqlFunction;
import java.util.HashMap;
import java.util.Map;

public final class JpqlFunctionGroup {
    private final String name;
    private final boolean aggregate;
    private final Map<String, JpqlFunction> rdbmsFunctions;

    public JpqlFunctionGroup(String name) {
        this(name, false);
    }

    public JpqlFunctionGroup(String name, JpqlFunction defaultFunction) {
        this(name, false);
        this.add(null, defaultFunction);
    }

    public JpqlFunctionGroup(String name, boolean aggregate) {
        this(name, aggregate, new HashMap<String, JpqlFunction>());
    }

    public JpqlFunctionGroup(String name, boolean aggregate, Map<String, JpqlFunction> rdbmsFunctions) {
        this.name = name;
        this.aggregate = aggregate;
        this.rdbmsFunctions = new HashMap<String, JpqlFunction>(rdbmsFunctions);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public JpqlFunction get(String rdbms) {
        return this.rdbmsFunctions.get(rdbms);
    }

    public boolean contains(String rdbms) {
        return this.rdbmsFunctions.containsKey(rdbms);
    }

    public void add(String rdbms, JpqlFunction function) {
        this.rdbmsFunctions.put(rdbms, function);
    }
}

