/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseUpdateCriteriaBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseUpdateCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionUpdateModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.query.ReturningCollectionUpdateModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractUpdateCollectionCriteriaBuilder<T, X extends BaseUpdateCriteriaBuilder<T, X>, Y>
extends BaseUpdateCriteriaBuilderImpl<T, X, Y> {
    private final String collectionName;
    private final String keyFunctionExpression;
    private final Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries;
    private final Map<String, String> collectionColumnBindingMap;
    private final Type<?> elementType;
    private final ExtendedAttribute<?, ?> collectionAttribute;
    private List<String> cachedBaseQueryStrings;

    public AbstractUpdateCollectionCriteriaBuilder(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, String alias, CTEManager.CTEKey cteName, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, queryContext, isMainQuery, clazz, alias, cteName, cteClass, result, listener);
        this.collectionName = collectionName;
        ExtendedManagedType extendedManagedType = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)this.entityType);
        this.collectionAttribute = extendedManagedType.getAttribute(collectionName);
        JoinNode join = this.joinManager.join(this.entityAlias + "." + collectionName, "_collection", JoinType.LEFT, false, true);
        this.elementType = join.getType();
        if (this.collectionAttribute.getJoinTable() == null && "".equals(this.collectionAttribute.getMappedBy())) {
            throw new IllegalArgumentException("Unsupported collection attribute that doesn't have a join table or a mapped by attribute!");
        }
        if (this.collectionAttribute.getMappedBy() != null) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail(null);
            rootNode.getAliasInfo().setAlias("_collection." + this.collectionAttribute.getMappedBy());
        }
        Map<String, ExtendedAttribute<?, ?>> collectionAttributeEntries = JpaUtils.getCollectionAttributeEntries(mainQuery.metamodel, this.entityType, this.collectionAttribute);
        this.keyFunctionExpression = this.collectionAttribute.getAttribute() instanceof MapAttribute ? "key(" + collectionName + ")" : (this.collectionAttribute.getAttribute() instanceof ListAttribute && !mainQuery.jpaProvider.isBag(this.entityType, collectionName) ? "index(" + collectionName + ")" : null);
        this.collectionColumnBindingMap = new LinkedHashMap<String, String>(collectionAttributeEntries.size());
        this.collectionAttributeEntries = collectionAttributeEntries;
    }

    public AbstractUpdateCollectionCriteriaBuilder(AbstractUpdateCollectionCriteriaBuilder<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.collectionName = builder.collectionName;
        this.keyFunctionExpression = builder.keyFunctionExpression;
        this.collectionColumnBindingMap = builder.collectionColumnBindingMap;
        this.collectionAttributeEntries = builder.collectionAttributeEntries;
        this.collectionAttribute = builder.collectionAttribute;
        this.elementType = builder.elementType;
    }

    @Override
    protected void addAttribute(String attributeName) {
        if (attributeName.equalsIgnoreCase(this.keyFunctionExpression)) {
            Integer attributeBindIndex = (Integer)this.setAttributeBindingMap.get(attributeName);
            if (attributeBindIndex != null) {
                throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
            }
            this.setAttributeBindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
            return;
        }
        ExtendedAttribute<?, ?> attributeEntry = this.collectionAttributeEntries.get(attributeName);
        if (attributeEntry == null) {
            TreeSet<String> set = new TreeSet<String>(this.collectionAttributeEntries.keySet());
            if (this.keyFunctionExpression != null) {
                set.add(this.keyFunctionExpression);
            }
            throw new IllegalArgumentException("The attribute [" + attributeName + "] does not exist or can't be bound! Allowed attributes are: " + set);
        }
        Integer attributeBindIndex = (Integer)this.setAttributeBindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.setAttributeBindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
    }

    @Override
    protected void prepareForModification(ClauseType changedClause) {
        super.prepareForModification(changedClause);
        this.cachedBaseQueryStrings = null;
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode) {
        if (externalRepresentation) {
            sbSelectFrom.append("UPDATE ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append('(').append(this.collectionName).append(") ");
            sbSelectFrom.append(this.entityAlias);
            this.appendSetClause(sbSelectFrom, externalRepresentation);
            this.appendWhereClause(sbSelectFrom, externalRepresentation);
        } else if (this.collectionAttribute.getJoinTable() == null) {
            sbSelectFrom.append("UPDATE ");
            sbSelectFrom.append(((EntityType)this.elementType).getName());
            sbSelectFrom.append(' ');
            sbSelectFrom.append("_collection");
            this.appendSetClause(sbSelectFrom, externalRepresentation);
            this.appendWhereClause(sbSelectFrom, externalRepresentation);
        } else {
            sbSelectFrom.append("SELECT 1 FROM ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append(' ');
            sbSelectFrom.append(this.entityAlias);
            sbSelectFrom.append(" LEFT JOIN ");
            sbSelectFrom.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
            this.appendWhereClause(sbSelectFrom, externalRepresentation);
            this.cachedBaseQueryStrings = new ArrayList<String>();
            StringBuilder sbSetExpressionQuery = new StringBuilder();
            List<SelectInfo> selectInfos = this.selectManager.getSelectInfos();
            for (Map.Entry attributeEntry : this.setAttributeBindingMap.entrySet()) {
                String expression = (String)attributeEntry.getKey();
                int collectionIndex = expression.indexOf(this.collectionName);
                if (collectionIndex == -1) {
                    expression = this.entityAlias + '.' + expression;
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(expression, 0, collectionIndex);
                    sb.append("_collection");
                    sb.append(expression, collectionIndex + this.collectionName.length(), expression.length());
                    expression = sb.toString();
                }
                this.fillCachedBaseQueryStrings(sbSetExpressionQuery, expression, selectInfos.get((Integer)attributeEntry.getValue()).getExpression());
            }
        }
    }

    private void fillCachedBaseQueryStrings(StringBuilder sbSetExpressionQuery, String attributePath, Expression value) {
        sbSetExpressionQuery.setLength(0);
        StringBuilder oldBuffer = this.queryGenerator.getQueryBuffer();
        this.queryGenerator.setClauseType(ClauseType.SET);
        this.queryGenerator.setQueryBuffer(sbSetExpressionQuery);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        sbSetExpressionQuery.append("SELECT 1 FROM ");
        sbSetExpressionQuery.append(this.entityType.getName());
        sbSetExpressionQuery.append(' ');
        sbSetExpressionQuery.append(this.entityAlias);
        sbSetExpressionQuery.append(" LEFT JOIN ");
        sbSetExpressionQuery.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
        sbSetExpressionQuery.append(" WHERE ");
        sbSetExpressionQuery.append(attributePath).append('=');
        value.accept((Expression.Visitor)this.queryGenerator);
        this.cachedBaseQueryStrings.add(sbSetExpressionQuery.toString());
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
        this.queryGenerator.setQueryBuffer(oldBuffer);
    }

    @Override
    protected boolean appendSetElementEntityPrefix(String trimmedPath) {
        return !trimmedPath.startsWith("_collection") && super.appendSetElementEntityPrefix(trimmedPath);
    }

    @Override
    protected void prepareAndCheck() {
        if (!this.needsCheck) {
            return;
        }
        JpaUtils.expandBindings(this.setAttributeBindingMap, this.collectionColumnBindingMap, this.collectionAttributeEntries, ClauseType.SET, this, this.keyFunctionExpression);
        super.prepareAndCheck();
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getQuery(includedModificationStates);
        }
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck(null, null));
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        if (this.collectionAttribute.getJoinTable() == null) {
            return super.getExecuteWithReturningQuery(exampleQuery, baseQuery, returningColumns, objectBuilder);
        }
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        String sql = extendedQuerySupport.getSql(this.em, baseQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, "_collection");
        JoinTable joinTable = this.collectionAttribute.getJoinTable();
        int joinTableIndex = SqlUtils.indexOfTableName(sql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(sql, joinTableIndex + joinTable.getTableName().length());
        String updateSql = "update " + joinTable.getTableName() + " set ";
        HashMap<String, String> columnOnlyRemappings = new HashMap<String, String>();
        HashMap<String, String> columnExpressionRemappings = new HashMap<String, String>();
        String[] discriminatorColumnCheck = this.mainQuery.jpaProvider.getDiscriminatorColumnCheck(this.entityType);
        String discriminatorPredicate = "";
        if (discriminatorColumnCheck != null) {
            discriminatorPredicate = ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1] + " and";
            columnExpressionRemappings.put(ownerAlias + "." + discriminatorColumnCheck[0] + "=" + discriminatorColumnCheck[1], "1=1");
        }
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                columnOnlyRemappings.put(collectionAlias + "." + (String)entry.getValue(), (String)entry.getKey());
                columnExpressionRemappings.put(collectionAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
            }
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            columnOnlyRemappings.put(ownerAlias + "." + (String)entry.getValue(), (String)entry.getKey());
            columnExpressionRemappings.put(ownerAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnOnlyRemappings.put(targetAlias + "." + (String)entry.getValue(), (String)entry.getKey());
            columnExpressionRemappings.put(targetAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        ArrayList<Query> setExpressionContainingUpdateQueries = new ArrayList<Query>();
        for (String cachedBaseQueryString : this.cachedBaseQueryStrings) {
            Query setExpressionQuery = this.em.createQuery(cachedBaseQueryString);
            parameterListNames.addAll(this.parameterManager.getParameterListNames(baseQuery));
            setExpressionContainingUpdateQueries.add(setExpressionQuery);
        }
        if (returningColumns == null) {
            return new CollectionUpdateModificationQuerySpecification(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getUpdateExampleQuery(), updateSql, setExpressionContainingUpdateQueries, columnOnlyRemappings, columnExpressionRemappings);
        }
        return new ReturningCollectionUpdateModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getUpdateExampleQuery(), updateSql, setExpressionContainingUpdateQueries, columnOnlyRemappings, columnExpressionRemappings, objectBuilder);
    }

    protected Query getUpdateExampleQuery() {
        String exampleQueryString = "UPDATE " + ValuesEntity.class.getSimpleName() + " SET value = NULL";
        return this.em.createQuery(exampleQueryString);
    }
}

