/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.SelectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AliasManager {
    private static final int DEFAULT_IMPLICIT_ALIAS_START_IDX = 0;
    private final AliasManager parent;
    private final Map<String, AliasInfo> aliasMap = new HashMap<String, AliasInfo>();
    private final Map<String, Integer> aliasCounterMap = new HashMap<String, Integer>();
    private final List<AliasManager> children = new ArrayList<AliasManager>();
    private String forbiddenAlias;

    public AliasManager() {
        this.parent = null;
    }

    public AliasManager(AliasManager parent) {
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public AliasManager getParent() {
        return this.parent;
    }

    public boolean isAliasAvailable(String alias) {
        if (this.getHierarchical(alias) == null) {
            return this.getChildAlias(alias) == null;
        }
        return false;
    }

    private Integer getCounter(String alias) {
        Integer counter = this.getCounterHierarchical(alias);
        return counter == null ? this.getChildCounter(alias) : counter;
    }

    private AliasInfo getChildAlias(String alias) {
        for (int i = 0; i < this.children.size(); ++i) {
            AliasManager child = this.children.get(i);
            AliasInfo info = child.getAliasInfoForBottomLevel(alias);
            if (info != null) {
                return info;
            }
            info = child.getChildAlias(alias);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private Integer getChildCounter(String alias) {
        for (int i = 0; i < this.children.size(); ++i) {
            AliasManager child = this.children.get(i);
            Integer info = child.aliasCounterMap.get(alias);
            if (info != null) {
                return info;
            }
            info = child.getChildCounter(alias);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public AliasInfo getAliasInfo(String alias) {
        AliasInfo aliasInfo = this.getHierarchical(alias);
        if (alias.equals(this.forbiddenAlias)) {
            throw new IllegalArgumentException("Usage of alias '" + alias + "' is forbidden!");
        }
        return aliasInfo;
    }

    public AliasInfo getAliasInfoForBottomLevel(String alias) {
        return this.aliasMap.get(alias);
    }

    public void applyFrom(AliasManager aliasManager) {
        this.aliasCounterMap.putAll(aliasManager.aliasCounterMap);
    }

    public String registerAliasInfo(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        if (!this.isAliasAvailable(alias)) {
            throw new IllegalArgumentException("Alias '" + alias + "' already exists");
        }
        this.aliasMap.put(alias, aliasInfo);
        this.aliasCounterMap.put(alias, 0);
        return alias;
    }

    public String generateRootAlias(String alias) {
        return this.generatePostfixedAlias(alias, 0);
    }

    public String generateJoinAlias(String alias) {
        return this.generatePostfixedAlias(alias, 1);
    }

    private String generatePostfixedAlias(String alias, int startIdx) {
        String nonPostfixed = alias;
        Integer counter = this.getCounter(alias);
        if (counter == null) {
            counter = startIdx;
        } else {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        alias = alias + "_" + counter;
        this.aliasCounterMap.put(nonPostfixed, counter);
        return alias;
    }

    private AliasInfo getHierarchical(String alias) {
        AliasInfo info = this.aliasMap.get(alias);
        if (info == null && this.parent != null) {
            info = this.parent.getHierarchical(alias);
        }
        return info;
    }

    private Integer getCounterHierarchical(String alias) {
        Integer counter = this.aliasCounterMap.get(alias);
        if (counter == null && this.parent != null) {
            counter = this.parent.getCounterHierarchical(alias);
        }
        return counter == null ? this.getChildCounter(alias) : counter;
    }

    public void unregisterAliasInfoForBottomLevel(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        if (alias != null) {
            this.aliasMap.remove(alias);
            int counter = this.aliasCounterMap.get(alias);
            if (alias.endsWith("_" + counter)) {
                if (counter == 0) {
                    this.aliasCounterMap.remove(alias);
                } else {
                    this.aliasCounterMap.put(alias, counter - 1);
                }
            }
        }
    }

    public String getForbiddenAlias() {
        return this.forbiddenAlias;
    }

    public void setForbiddenAlias(String forbiddenAlias) {
        this.forbiddenAlias = forbiddenAlias;
    }

    public Map<String, AliasInfo> getAliasMapForBottomLevel() {
        return this.aliasMap;
    }

    public boolean isSelectAlias(String alias) {
        AliasInfo info = this.aliasMap.get(alias);
        if (info != null) {
            return info instanceof SelectInfo;
        }
        return false;
    }
}

