/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.BaseOngoingFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.DefaultOrderByElement;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.SetOperationQuerySpecification;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public abstract class BaseFinalSetOperationBuilderImpl<T, X extends BaseFinalSetOperationBuilder<T, X>, Y extends BaseFinalSetOperationBuilderImpl<T, X, Y>>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, Y>
implements BaseFinalSetOperationBuilder<T, X>,
BaseOngoingFinalSetOperationBuilder<T, X> {
    protected T endSetResult;
    protected final SetOperationManager setOperationManager;
    protected final List<DefaultOrderByElement> orderByElements;

    public BaseFinalSetOperationBuilderImpl(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, SetOperationType operator, boolean nested, T endSetResult) {
        super(mainQuery, queryContext, isMainQuery, DbmsStatementType.SELECT, clazz, null, null, false, null, null);
        this.endSetResult = endSetResult;
        this.setOperationManager = new SetOperationManager(operator, nested);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(0);
    }

    public BaseFinalSetOperationBuilderImpl(BaseFinalSetOperationBuilderImpl<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.setOperationManager = new SetOperationManager(builder.setOperationManager, queryContext, joinManagerMapping, copyContext);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(builder.orderByElements);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.setOperationManager.isEmpty();
    }

    private static boolean isNestedAndComplex(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            BaseFinalSetOperationBuilderImpl builder = (BaseFinalSetOperationBuilderImpl)queryBuilder;
            return builder.setOperationManager.isNested() && (builder.setOperationManager.hasSetOperations() || BaseFinalSetOperationBuilderImpl.isNestedAndComplex(builder.setOperationManager.getStartQueryBuilder()));
        }
        return false;
    }

    @Override
    public X orderBy(String expression, boolean ascending, boolean nullFirst) {
        this.prepareAndCheck();
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> leftMostQuery = this.getLeftMost(this.setOperationManager.getStartQueryBuilder());
        AliasInfo aliasInfo = leftMostQuery.aliasManager.getAliasInfo(expression);
        int position = aliasInfo == null ? this.cbf.getExtendedQuerySupport().getSqlSelectAttributePosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression) : this.cbf.getExtendedQuerySupport().getSqlSelectAliasPosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression);
        this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, this.isNullable(this, expression), nullFirst));
        return (X)this;
    }

    private boolean isNullable(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, String expression) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            SetOperationManager setOpManager = ((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager;
            if (this.isNullable(setOpManager.getStartQueryBuilder(), expression)) {
                return true;
            }
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOp : setOpManager.getSetOperations()) {
                if (!this.isNullable(setOp, expression)) continue;
                return true;
            }
            return false;
        }
        AliasInfo aliasInfo = queryBuilder.aliasManager.getAliasInfo(expression);
        if (aliasInfo == null) {
            JoinNode rootNode;
            List<SelectInfo> selectInfos = queryBuilder.selectManager.getSelectInfos();
            if (selectInfos.size() > 1) {
                throw new IllegalArgumentException("Can't order by an attribute when having multiple select items! Use a select alias!");
            }
            if (selectInfos.isEmpty()) {
                rootNode = queryBuilder.joinManager.getRootNodeOrFail("Can't order by an attribute when having multiple query roots! Use a select alias!");
            } else {
                if (!(selectInfos.get(0).get() instanceof PathExpression)) {
                    throw new IllegalArgumentException("Can't order by an attribute when the select item is a complex expression! Use a select alias!");
                }
                rootNode = (JoinNode)((PathExpression)selectInfos.get(0).get()).getBaseNode();
            }
            if (JpaMetamodelUtils.getAttribute(rootNode.getManagedType(), (String)expression) == null) {
                throw new IllegalArgumentException("The attribute '" + expression + "' does not exist on the type '" + rootNode.getJavaType().getName() + "'! Did you maybe forget to use a select alias?");
            }
            ArrayList<PropertyExpression> path = new ArrayList<PropertyExpression>(2);
            path.add(new PropertyExpression(rootNode.getAlias()));
            path.add(new PropertyExpression(expression));
            return this.joinManager.hasFullJoin() || ExpressionUtils.isNullable(this.getMetamodel(), queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), (Expression)new PathExpression(path, (PathReference)new SimplePathReference(rootNode, expression, null), false, false));
        }
        return this.joinManager.hasFullJoin() || ExpressionUtils.isNullable(this.getMetamodel(), queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), ((SelectInfo)aliasInfo).getExpression());
    }

    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getLeftMost(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            return this.getLeftMost(((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager.getStartQueryBuilder());
        }
        return queryBuilder;
    }

    protected List<? extends OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public T getEndSetResult() {
        return this.endSetResult;
    }

    public void setEndSetResult(T endSetResult) {
        this.endSetResult = endSetResult;
    }

    public T endSet() {
        this.setOperationEnded = true;
        this.prepareAndCheck();
        return this.endSetResult;
    }

    @Override
    protected void prepareAndCheck() {
        this.nodesToFetch = Collections.emptySet();
    }

    public void verifyBuilderEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> currentBuilder) {
        if (!this.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
        super.verifyBuilderEnded();
        if (currentBuilder == this.setOperationManager.getStartQueryBuilder()) {
            return;
        }
        this.verifySetOperationEnded(this.setOperationManager.getStartQueryBuilder());
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
            if (currentBuilder == setOperand) {
                return;
            }
            this.verifySetOperationEnded(setOperand);
        }
    }

    private void verifySetOperationEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        if (builder instanceof BaseFinalSetOperationBuilderImpl) {
            builder.verifyBuilderEnded();
        } else if (!builder.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
    }

    @Override
    public Expression asExpression(boolean externalRepresentation) {
        SetOperationManager operationManager = this.setOperationManager;
        if (operationManager.getOperator() == null || !operationManager.hasSetOperations()) {
            return this.asExpression(operationManager.getStartQueryBuilder(), externalRepresentation);
        }
        ArrayList<Object> setOperationArgs = new ArrayList<Object>(operationManager.getSetOperations().size() + 2);
        setOperationArgs.add(new StringLiteral("SET_" + operationManager.getOperator().name()));
        setOperationArgs.add(this.asExpression(operationManager.getStartQueryBuilder(), externalRepresentation));
        List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperands = operationManager.getSetOperations();
        int operandsSize = setOperands.size();
        for (int i = 0; i < operandsSize; ++i) {
            setOperationArgs.add(this.asExpression(setOperands.get(i), externalRepresentation));
        }
        List<OrderByElement> orderByElements = this.getOrderByElements();
        if (orderByElements.size() > 0) {
            setOperationArgs.add(new StringLiteral("ORDER_BY"));
            int orderByElementsSize = orderByElements.size();
            for (int i = 0; i < orderByElementsSize; ++i) {
                setOperationArgs.add(new StringLiteral(orderByElements.get(i).toString()));
            }
        }
        if (this.hasLimit()) {
            if (this.maxResults != Integer.MAX_VALUE) {
                setOperationArgs.add(new StringLiteral("LIMIT"));
                setOperationArgs.add(new NumericLiteral(Integer.toString(this.maxResults), NumericType.INTEGER));
            }
            if (this.firstResult != 0) {
                setOperationArgs.add(new StringLiteral("OFFSET"));
                setOperationArgs.add(new NumericLiteral(Integer.toString(this.firstResult), NumericType.INTEGER));
            }
        }
        return new FunctionExpression("FUNCTION", setOperationArgs);
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode) {
        boolean nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(this.setOperationManager.getStartQueryBuilder());
        if (nested) {
            sbSelectFrom.append('(');
        }
        this.setOperationManager.getStartQueryBuilder().buildBaseQueryString(sbSelectFrom, externalRepresentation, lateralJoinNode);
        if (nested) {
            sbSelectFrom.append(')');
        }
        if (this.setOperationManager.hasSetOperations()) {
            String operator = this.getOperator(this.setOperationManager.getOperator());
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
                sbSelectFrom.append("\n");
                sbSelectFrom.append(operator);
                sbSelectFrom.append("\n");
                nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(setOperand);
                if (nested) {
                    sbSelectFrom.append('(');
                }
                setOperand.buildBaseQueryString(sbSelectFrom, externalRepresentation, lateralJoinNode);
                if (!nested) continue;
                sbSelectFrom.append(')');
            }
            this.applySetOrderBy(sbSelectFrom);
            this.applyJpaLimit(sbSelectFrom);
        }
    }

    protected void applySetOrderBy(StringBuilder sbSelectFrom) {
        if (this.orderByElements.isEmpty()) {
            return;
        }
        sbSelectFrom.append("\nORDER BY ");
        for (int i = 0; i < this.orderByElements.size(); ++i) {
            if (i != 0) {
                sbSelectFrom.append(", ");
            }
            DefaultOrderByElement elem = this.orderByElements.get(i);
            sbSelectFrom.append(elem.getName());
            if (elem.isAscending()) {
                sbSelectFrom.append(" ASC");
            } else {
                sbSelectFrom.append(" DESC");
            }
            if (!elem.isNullable()) continue;
            if (elem.isNullsFirst()) {
                sbSelectFrom.append(" NULLS FIRST");
                continue;
            }
            sbSelectFrom.append(" NULLS LAST");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected TypedQuery<T> getTypedQuery(StringBuilder lateralSb, JoinNode lateralJoinNode) {
        void var8_11;
        Query baseQuery;
        Object customQueryParticipants;
        AbstractCustomQuery customQuery;
        if (lateralSb != null) {
            throw new IllegalStateException("Lateral join with set operations is not yet supported!");
        }
        HashSet<String> parameterListNames = new HashSet<String>();
        Query leftMostQuery = this.setOperationManager.getStartQueryBuilder().getTypedQueryForFinalOperationBuilder();
        this.parameterManager.collectParameterListNames(leftMostQuery, parameterListNames);
        if (leftMostQuery instanceof CustomSQLQuery) {
            customQuery = (CustomSQLQuery)leftMostQuery;
            customQueryParticipants = customQuery.getParticipatingQueries();
            baseQuery = customQueryParticipants.get(0);
        } else if (leftMostQuery instanceof CustomSQLTypedQuery) {
            customQuery = (CustomSQLTypedQuery)leftMostQuery;
            customQueryParticipants = customQuery.getParticipatingQueries();
            baseQuery = customQueryParticipants.get(0);
        } else {
            baseQuery = leftMostQuery;
        }
        ArrayList<Query> setOperands = new ArrayList<Query>();
        for (AbstractCommonQueryBuilder abstractCommonQueryBuilder : this.setOperationManager.getSetOperations()) {
            Query q = abstractCommonQueryBuilder.getQuery();
            setOperands.add(q);
            this.parameterManager.collectParameterListNames(q, parameterListNames);
        }
        String limit = null;
        Object var8_9 = null;
        if (!this.isMainQuery) {
            if (this.firstResult != 0) {
                String string = Integer.toString(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                limit = Integer.toString(this.maxResults);
            }
        }
        List<String> keyRestrictedLeftJoinAliases = Collections.emptyList();
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        SetOperationQuerySpecification querySpecification = new SetOperationQuerySpecification(this, leftMostQuery, baseQuery, setOperands, this.setOperationManager.getOperator(), this.getOrderByElements(), this.setOperationManager.isNested(), this.parameterManager.getParameters(), parameterListNames, limit, (String)var8_11, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        if (this.isMainQuery) {
            if (this.firstResult != 0) {
                query.setFirstResult(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                query.setMaxResults(this.maxResults);
            }
        }
        this.parameterManager.parameterizeQuery(query);
        return this.applyObjectBuilder(query);
    }

    protected String getOperator(SetOperationType type) {
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public TypedQuery<T> getQuery() {
        return this.getTypedQuery(null, null);
    }

    public List<T> getResultList() {
        return this.getTypedQuery(null, null).getResultList();
    }

    public T getSingleResult() {
        return (T)this.getTypedQuery(null, null).getSingleResult();
    }
}

