/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseUpdateCriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractModificationCriteriaBuilder;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterRegistrationVisitor;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;

public abstract class BaseUpdateCriteriaBuilderImpl<T, X extends BaseUpdateCriteriaBuilder<T, X>, Y>
extends AbstractModificationCriteriaBuilder<T, X, Y>
implements BaseUpdateCriteriaBuilder<T, X>,
SubqueryBuilderListener<X>,
ExpressionBuilderEndedListener {
    protected final Map<String, Integer> setAttributeBindingMap = new LinkedHashMap<String, Integer>();
    private SubqueryInternalBuilder<X> currentSubqueryBuilder;
    private String currentAttribute;

    public BaseUpdateCriteriaBuilderImpl(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, String alias, CTEManager.CTEKey cteKey, Class<?> cteClass, Y result, CTEBuilderListener listener) {
        super(mainQuery, queryContext, isMainQuery, DbmsStatementType.UPDATE, clazz, alias, cteKey, cteClass, result, listener);
    }

    public BaseUpdateCriteriaBuilderImpl(BaseUpdateCriteriaBuilderImpl<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        builder.verifyBuilderEnded();
        for (Map.Entry<String, Integer> entry : builder.setAttributeBindingMap.entrySet()) {
            this.setAttributeBindingMap.put(this.entityType.getName(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectParameters() {
        ParameterRegistrationVisitor parameterRegistrationVisitor = this.parameterManager.getParameterRegistrationVisitor();
        ClauseType oldClauseType = parameterRegistrationVisitor.getClauseType();
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> oldQueryBuilder = parameterRegistrationVisitor.getQueryBuilder();
        try {
            parameterRegistrationVisitor.setQueryBuilder(this);
            parameterRegistrationVisitor.setClauseType(ClauseType.SET);
            this.selectManager.acceptVisitor((Expression.Visitor)parameterRegistrationVisitor);
            parameterRegistrationVisitor.setClauseType(ClauseType.WHERE);
            this.whereManager.acceptVisitor((Expression.Visitor)parameterRegistrationVisitor);
        }
        finally {
            parameterRegistrationVisitor.setClauseType(oldClauseType);
            parameterRegistrationVisitor.setQueryBuilder(oldQueryBuilder);
        }
    }

    public X set(String attributeName, Object value) {
        this.verifyBuilderEnded();
        this.addAttribute(attributeName);
        ParameterExpression attributeExpression = this.parameterManager.addParameterExpression(value, ClauseType.SET, this);
        this.selectManager.select((Expression)attributeExpression, null);
        return (X)this;
    }

    public X setExpression(String attributeName, String expression) {
        this.verifyBuilderEnded();
        this.addAttribute(attributeName);
        Expression attributeExpression = this.expressionFactory.createSimpleExpression(expression, false);
        this.parameterManager.collectParameterRegistrations(attributeExpression, ClauseType.SET, this);
        this.selectManager.select(attributeExpression, null);
        return (X)this;
    }

    public SubqueryInitiator<X> set(String attribute) {
        this.verifySubqueryBuilderEnded();
        this.addAttribute(attribute);
        this.currentAttribute = attribute;
        return this.subqueryInitFactory.createSubqueryInitiator(this, this, false, ClauseType.SET);
    }

    public MultipleSubqueryInitiator<X> setSubqueries(String attribute, String expression) {
        this.verifySubqueryBuilderEnded();
        this.addAttribute(attribute);
        this.currentAttribute = attribute;
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        MultipleSubqueryInitiatorImpl<BaseUpdateCriteriaBuilderImpl> initiator = new MultipleSubqueryInitiatorImpl<BaseUpdateCriteriaBuilderImpl>(this, expr, this, this.subqueryInitFactory, ClauseType.SET);
        return initiator;
    }

    public SubqueryBuilder<X> set(String attribute, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        this.addAttribute(attribute);
        this.currentAttribute = attribute;
        return this.subqueryInitFactory.createSubqueryBuilder(this, this, false, criteriaBuilder, ClauseType.SET);
    }

    private void verifySubqueryBuilderEnded() {
        if (this.currentAttribute != null) {
            throw new BuilderChainingException("An initiator was not ended properly.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("An subquery builder was not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        Expression attributeExpression = builder.getExpression();
        this.parameterManager.collectParameterRegistrations(attributeExpression, ClauseType.SET, this);
        this.selectManager.select(attributeExpression, null);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        if (this.currentSubqueryBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        SubqueryExpression attributeExpression = new SubqueryExpression(builder);
        this.parameterManager.collectParameterRegistrations((Expression)attributeExpression, ClauseType.SET, this);
        this.selectManager.select((Expression)attributeExpression, null);
        this.currentAttribute = null;
        this.currentSubqueryBuilder = null;
    }

    @Override
    public void onBuilderStarted(SubqueryInternalBuilder<X> builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to start a builder without an originating initiator.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentSubqueryBuilder = builder;
    }

    @Override
    public void onReplaceBuilder(SubqueryInternalBuilder<X> oldBuilder, SubqueryInternalBuilder<X> newBuilder) {
        throw new IllegalArgumentException("Replace not valid!");
    }

    @Override
    public void onInitiatorStarted(SubqueryInitiator<?> initiator) {
        throw new IllegalArgumentException("Initiator started not valid!");
    }

    protected void addAttribute(String attributeName) {
        JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
        jpaMetamodelAccessor.getBasicAttributePath((Metamodel)this.getMetamodel(), (ManagedType)this.entityType, attributeName);
        Integer attributeBindIndex = this.setAttributeBindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.setAttributeBindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
    }

    @Override
    protected void prepareSelect() {
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode) {
        sbSelectFrom.append("UPDATE ");
        sbSelectFrom.append(this.entityType.getName()).append(' ');
        sbSelectFrom.append(this.entityAlias);
        this.appendSetClause(sbSelectFrom, externalRepresentation);
        this.appendWhereClause(sbSelectFrom, externalRepresentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendSetClause(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        sbSelectFrom.append(" SET ");
        this.queryGenerator.setClauseType(ClauseType.SET);
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        boolean originalExternalRepresentation = this.queryGenerator.isExternalRepresentation();
        this.queryGenerator.setExternalRepresentation(externalRepresentation);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        try {
            List<SelectInfo> selectInfos = this.selectManager.getSelectInfos();
            Iterator<Map.Entry<String, Integer>> setAttributeIter = this.setAttributeBindingMap.entrySet().iterator();
            if (setAttributeIter.hasNext()) {
                Map.Entry<String, Integer> attributeEntry = setAttributeIter.next();
                this.appendSetElement(sbSelectFrom, attributeEntry.getKey(), selectInfos.get(attributeEntry.getValue()).getExpression());
                while (setAttributeIter.hasNext()) {
                    attributeEntry = setAttributeIter.next();
                    sbSelectFrom.append(',');
                    this.appendSetElement(sbSelectFrom, attributeEntry.getKey(), selectInfos.get(attributeEntry.getValue()).getExpression());
                }
            }
        }
        finally {
            this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
            this.queryGenerator.setClauseType(null);
            this.queryGenerator.setExternalRepresentation(originalExternalRepresentation);
        }
    }

    protected final void appendSetElement(StringBuilder sbSelectFrom, String attribute, Expression valueExpression) {
        String trimmedPath = attribute.trim();
        if (this.appendSetElementEntityPrefix(trimmedPath)) {
            sbSelectFrom.append(this.entityAlias).append('.');
        }
        sbSelectFrom.append(attribute);
        sbSelectFrom.append(" = ");
        this.queryGenerator.generate(valueExpression);
    }

    protected boolean appendSetElementEntityPrefix(String trimmedPath) {
        String indexStart = "index(";
        String keyStart = "key(";
        return !trimmedPath.regionMatches(true, 0, indexStart, 0, indexStart.length()) && !trimmedPath.regionMatches(true, 0, keyStart, 0, keyStart.length());
    }
}

